/*
 * Decompiled with CFR 0.152.
 */
package me.bunnky.idreamofeasy.slimefun.items;

import io.github.thebusybiscuit.slimefun4.api.events.PlayerRightClickEvent;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.items.settings.IntRangeSetting;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemUseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.bunnky.idreamofeasy.utils.IDOEUtility;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.block.Biome;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class BiomeCompass
extends SimpleSlimefunItem<ItemUseHandler> {
    private final ItemSetting<Integer> r = new IntRangeSetting((SlimefunItem)this, "range", 1, 100, Integer.MAX_VALUE);
    private static final int COOLDOWN_TICKS = 200;
    private final Biome[] biomes;
    private Map<Player, Integer> playerBiomeSelection = new HashMap<Player, Integer>();
    private Map<Player, Map<Biome, List<Location>>> playerBiomeCache = new HashMap<Player, Map<Biome, List<Location>>>();
    private Map<Player, Map<Biome, Location>> playerDiscoveredBiomes = new HashMap<Player, Map<Biome, Location>>();

    public BiomeCompass(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
        this.addItemSetting(new ItemSetting[]{this.r});
        IDOEUtility.setGlow(item);
        this.biomes = Biome.values();
    }

    @NotNull
    public ItemUseHandler getItemHandler() {
        return this::onRightClick;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    private void onRightClick(@NotNull PlayerRightClickEvent e) {
        Player p = e.getPlayer();
        int selectedBiomeIndex = this.playerBiomeSelection.getOrDefault(p, 0);
        if (p.hasCooldown(Material.COMPASS)) {
            p.sendMessage("\u00a7cYou must wait before using this again!");
            return;
        }
        if (p.isSneaking()) {
            if (e.getInteractEvent().getClickedBlock() == null) {
                selectedBiomeIndex = (selectedBiomeIndex + 1) % this.biomes.length;
                this.playerBiomeSelection.put(p, selectedBiomeIndex);
            } else {
                selectedBiomeIndex = (selectedBiomeIndex - 1 + this.biomes.length) % this.biomes.length;
                this.playerBiomeSelection.put(p, selectedBiomeIndex);
            }
            p.sendMessage("\u00a7eSelected biome: " + String.valueOf(ChatColor.GOLD) + this.biomes[selectedBiomeIndex].name());
            return;
        }
        Location closestBiomeLocation = this.findClosestBiome(p, p.getLocation(), this.biomes[selectedBiomeIndex]);
        if (closestBiomeLocation != null) {
            p.setCompassTarget(closestBiomeLocation);
            double distance = p.getLocation().distance(closestBiomeLocation);
            p.sendMessage("\u00a7aFound " + String.valueOf(ChatColor.GREEN) + this.biomes[selectedBiomeIndex].name() + " \u00a7abiome, " + String.valueOf(ChatColor.GREEN) + (int)distance + " \u00a7ablocks away!");
            Map playerDiscovered = this.playerDiscoveredBiomes.computeIfAbsent(p, k -> new HashMap());
            playerDiscovered.put(this.biomes[selectedBiomeIndex], closestBiomeLocation);
            p.setCooldown(Material.COMPASS, 200);
            p.playSound((Entity)p, Sound.ENTITY_PLAYER_LEVELUP, SoundCategory.PLAYERS, 0.5f, 2.0f);
        } else {
            p.sendMessage("\u00a7cNo " + String.valueOf(ChatColor.DARK_RED) + this.biomes[selectedBiomeIndex].name() + " \u00a7cbiome nearby.");
            p.setCooldown(Material.COMPASS, 200);
            p.playSound((Entity)p, Sound.BLOCK_ANVIL_LAND, SoundCategory.PLAYERS, 0.4f, 1.0f);
        }
        p.spawnParticle(Particle.EFFECT, p.getLocation().add(0.5, 0.5, 0.5), 30, 0.3, 0.3, 0.3, 0.05);
    }

    private Location findClosestBiome(Player player, Location playerLocation, Biome targetBiome) {
        ArrayList<Location> foundLocations = new ArrayList<Location>();
        int radius = (Integer)this.r.getValue();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                int biomeX = playerLocation.getBlockX() + x;
                int biomeZ = playerLocation.getBlockZ() + z;
                Biome biome = playerLocation.getWorld().getBiome(biomeX, biomeZ);
                if (biome != targetBiome) continue;
                Location foundLocation = new Location(playerLocation.getWorld(), (double)biomeX, (double)playerLocation.getWorld().getHighestBlockYAt(biomeX, biomeZ), (double)biomeZ);
                foundLocations.add(foundLocation);
            }
        }
        if (!foundLocations.isEmpty()) {
            Location closestNewBiome = (Location)foundLocations.get(0);
            Map playerCache = this.playerBiomeCache.computeIfAbsent(player, k -> new HashMap());
            playerCache.computeIfAbsent(targetBiome, k -> new ArrayList()).add(closestNewBiome);
            return closestNewBiome;
        }
        Map playerCache = this.playerBiomeCache.computeIfAbsent(player, k -> new HashMap());
        List cachedLocations = (List)playerCache.get(targetBiome);
        if (cachedLocations != null) {
            Location closestCached = null;
            double closestCachedDistance = Double.MAX_VALUE;
            for (Location loc : cachedLocations) {
                double distance = loc.distance(playerLocation);
                if (!(distance < closestCachedDistance)) continue;
                closestCachedDistance = distance;
                closestCached = loc;
            }
            return closestCached;
        }
        return null;
    }

    public static int getRange() {
        return (Integer)Slimefun.getItemCfg().getOrSetDefault("IDOE_BIOMECOMPASS.range", (Object)100);
    }
}

