/*
 * Decompiled with CFR 0.152.
 */
package me.bunnky.idreamofeasy.slimefun.machines;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.core.services.sounds.SoundEffect;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.handlers.VanillaInventoryDropHandler;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import me.bunnky.idreamofeasy.utils.IDOEUtility;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.block.Hopper;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class PlayerHopper
extends SimpleSlimefunItem<BlockTicker>
implements EnergyNetComponent {
    private final ItemSetting<Boolean> silent = new ItemSetting((SlimefunItem)this, "silent", (Object)false);
    private final ItemSetting<Boolean> toggleable = new ItemSetting((SlimefunItem)this, "toggleable-with-redstone", (Object)false);
    private final int cap;
    private final int ecost;

    public PlayerHopper(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, int ecost, int cap) {
        super(itemGroup, item, recipeType, recipe);
        IDOEUtility.setGlow(item);
        this.cap = cap;
        this.ecost = ecost;
        this.addItemSetting(new ItemSetting[]{this.silent, this.toggleable});
        this.addItemHandler(new ItemHandler[]{new VanillaInventoryDropHandler(Hopper.class)});
    }

    @NotNull
    public BlockTicker getItemHandler() {
        return new BlockTicker(){

            public void tick(Block b, SlimefunItem sfItem, Config config) {
                org.bukkit.block.data.type.Hopper hopper;
                if (b.getType() != Material.HOPPER) {
                    BlockStorage.clearBlockInfo((Block)b);
                    return;
                }
                if (((Boolean)PlayerHopper.this.toggleable.getValue()).booleanValue() && !(hopper = (org.bukkit.block.data.type.Hopper)b.getBlockData()).isEnabled()) {
                    return;
                }
                Location loc = b.getLocation();
                boolean playSound = false;
                double xMin = -1.0;
                double xMax = 1.0;
                double yMin = 0.0;
                double yMax = 2.0;
                double zMin = -1.0;
                double zMax = 1.0;
                List players = (List)loc.getNearbyPlayers(xMax - xMin, yMax - yMin, zMax - zMin);
                for (Player p : players) {
                    if (!Slimefun.getProtectionManager().hasPermission((OfflinePlayer)p, b, Interaction.INTERACT_BLOCK)) {
                        return;
                    }
                    Location ploc = p.getLocation();
                    double blockCenterX = loc.getX() + 0.5;
                    double blockCenterY = loc.getY() + 0.5;
                    double blockCenterZ = loc.getZ() + 0.5;
                    if (!(ploc.getX() >= blockCenterX + xMin) || !(ploc.getX() <= blockCenterX + xMax) || !(ploc.getY() >= blockCenterY + yMin) || !(ploc.getY() <= blockCenterY + yMax) || !(ploc.getZ() >= blockCenterZ + zMin) || !(ploc.getZ() <= blockCenterZ + zMax)) continue;
                    Hopper h = (Hopper)b.getState();
                    ItemStack[] items = p.getInventory().getContents();
                    ItemStack[] hItems = h.getInventory().getContents();
                    int emptySlots = (int)Arrays.stream(hItems).filter(Objects::isNull).count();
                    if (!h.getInventory().getViewers().isEmpty()) {
                        return;
                    }
                    for (ItemStack item : items) {
                        if (item == null || PlayerHopper.this.getCharge(loc) < PlayerHopper.this.ecost) continue;
                        ItemStack offhandItem = p.getInventory().getItemInOffHand();
                        ItemStack[] armorContents = p.getInventory().getArmorContents();
                        boolean isArmorOrOffhand = false;
                        for (ItemStack armorItem : armorContents) {
                            if (armorItem == null || !item.isSimilar(armorItem)) continue;
                            isArmorOrOffhand = true;
                            break;
                        }
                        if (isArmorOrOffhand || item.isSimilar(offhandItem) || emptySlots <= 0) continue;
                        HashMap leftover = h.getInventory().addItem(new ItemStack[]{item});
                        if (leftover.isEmpty()) {
                            p.getInventory().removeItem(new ItemStack[]{item});
                            PlayerHopper.this.removeCharge(loc, PlayerHopper.this.ecost);
                            --emptySlots;
                            b.getWorld().spawnParticle(Particle.CRIT, b.getLocation().add(0.5, 1.0, 0.5), 10, 0.3, 0.3, 0.3, 0.05);
                            playSound = true;
                        } else {
                            for (ItemStack remaining : leftover.values()) {
                                p.getInventory().addItem(new ItemStack[]{remaining});
                            }
                        }
                        if (!playSound || ((Boolean)PlayerHopper.this.silent.getValue()).booleanValue()) continue;
                        SoundEffect.INFUSED_HOPPER_TELEPORT_SOUND.playAt(b);
                    }
                }
            }

            public boolean isSynchronized() {
                return true;
            }
        };
    }

    @NotNull
    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }

    public int getCapacity() {
        return this.cap;
    }
}

