/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.guizhanlib.slimefun.items.core;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.guizhanlib.utils.StringUtil;

public enum BasicMetal {
    IRON("Iron", "\u94c1"),
    GOLD("Gold", "\u91d1"),
    TIN("Tin", "\u9521"),
    COPPER("Copper", "\u94dc"),
    SILVER("Silver", "\u94f6"),
    ALUMINUM("Aluminum", "\u94dd"),
    LEAD("Lead", "\u94c5"),
    ZINC("Zinc", "\u950c"),
    MAGNESIUM("Magnesium", "\u9541");

    private static final BasicMetal[] valuesCache;
    private static final Map<String, BasicMetal> englishLookup;
    private static final Map<String, BasicMetal> chineseLookup;
    private final String english;
    private final String chinese;

    @ParametersAreNonnullByDefault
    private BasicMetal(String english, String chinese) {
        this.english = english;
        this.chinese = chinese;
    }

    @Nullable
    public static BasicMetal fromEnglish(@Nonnull String english) {
        Preconditions.checkArgument((english != null ? 1 : 0) != 0, (Object)"\u82f1\u6587\u4e0d\u80fd\u4e3a\u7a7a");
        return englishLookup.get(StringUtil.humanize(english));
    }

    @Nullable
    public static BasicMetal fromChinese(@Nonnull String chinese) {
        Preconditions.checkArgument((chinese != null ? 1 : 0) != 0, (Object)"\u4e2d\u6587\u4e0d\u80fd\u4e3a\u7a7a");
        return chineseLookup.get(chinese);
    }

    @Nonnull
    public String toString() {
        return this.getChinese();
    }

    public String getEnglish() {
        return this.english;
    }

    public String getChinese() {
        return this.chinese;
    }

    static {
        valuesCache = BasicMetal.values();
        englishLookup = new HashMap<String, BasicMetal>();
        chineseLookup = new HashMap<String, BasicMetal>();
        for (BasicMetal metal : valuesCache) {
            englishLookup.put(metal.getEnglish(), metal);
            chineseLookup.put(metal.getChinese(), metal);
        }
    }
}

