/*
 * Decompiled with CFR 0.152.
 */
package me.bunnky.idreamofeasy.slimefun.items.idols;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import me.bunnky.idreamofeasy.slimefun.items.idols.Idol;
import net.guizhanss.guizhanlib.minecraft.utils.compatibility.EnchantmentX;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class TerranIdol
extends Idol {
    private final Random random = new Random();

    public TerranIdol(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
    }

    @Override
    protected void handleEvent(Event e) {
        if (e instanceof BlockBreakEvent) {
            this.onBlockBreak((BlockBreakEvent)e);
        } else if (e instanceof EntityDeathEvent) {
            this.onEntityDeath((EntityDeathEvent)e);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent e) {
        Player p = e.getPlayer();
        Material type = e.getBlock().getType();
        ItemStack tool = p.getInventory().getItemInMainHand();
        int fortuneLevel = tool.getEnchantmentLevel(EnchantmentX.FORTUNE);
        if (!p.hasPotionEffect(PotionEffectType.HASTE) && this.random.nextDouble() < 0.5) {
            p.addPotionEffect(new PotionEffect(PotionEffectType.HASTE, 100, 1));
            this.sendMessage(p, this.getItemName() + ": \u00a7r\u00a7a+Haste II");
        }
        switch (type) {
            case DIAMOND_ORE: 
            case GOLD_ORE: 
            case IRON_ORE: 
            case EMERALD_ORE: 
            case COAL_ORE: 
            case COPPER_ORE: 
            case REDSTONE_ORE: 
            case LAPIS_ORE: 
            case DEEPSLATE_DIAMOND_ORE: 
            case DEEPSLATE_GOLD_ORE: 
            case DEEPSLATE_IRON_ORE: 
            case DEEPSLATE_EMERALD_ORE: 
            case DEEPSLATE_COAL_ORE: 
            case DEEPSLATE_COPPER_ORE: 
            case DEEPSLATE_REDSTONE_ORE: 
            case DEEPSLATE_LAPIS_ORE: 
            case NETHER_GOLD_ORE: 
            case NETHER_QUARTZ_ORE: {
                if (!(this.random.nextDouble() < 0.2)) break;
                e.setDropItems(false);
                Collection normalDrops = e.getBlock().getDrops(p.getInventory().getItemInMainHand(), (Entity)p);
                for (ItemStack drop : normalDrops) {
                    int extra = fortuneLevel > 0 ? this.random.nextInt(fortuneLevel + 1) : 0;
                    ItemStack doubledDrop = new ItemStack(drop.getType(), drop.getAmount() * (2 + extra));
                    e.getBlock().getWorld().dropItemNaturally(e.getBlock().getLocation(), doubledDrop);
                }
                this.sendMessage(p, this.getItemName() + ": \u00a7r\u00a7aDoubled ore drops!");
                break;
            }
            case CARROTS: 
            case POTATOES: 
            case BEETROOTS: 
            case WHEAT: 
            case NETHER_WART: {
                if (!(this.random.nextDouble() < 0.2)) break;
                e.setDropItems(false);
                Collection normalDrops = e.getBlock().getDrops(p.getInventory().getItemInMainHand(), (Entity)p);
                for (ItemStack drop : normalDrops) {
                    Material dropType = drop.getType();
                    int extra = fortuneLevel > 0 ? this.random.nextInt(fortuneLevel + 1) : 0;
                    int newAmount = drop.getAmount() * (2 + extra);
                    ItemStack doubledDrop = new ItemStack(dropType, newAmount);
                    e.getBlock().getWorld().dropItemNaturally(e.getBlock().getLocation(), doubledDrop);
                }
                this.sendMessage(p, this.getItemName() + ": \u00a7r\u00a7aDoubled crops!");
                break;
            }
            case COCOA: 
            case SUGAR_CANE: 
            case PUMPKIN: 
            case MELON: {
                if (!(this.random.nextDouble() < 0.2)) break;
                e.setDropItems(false);
                ItemStack cropDrop = new ItemStack(type, 2);
                e.getBlock().getWorld().dropItemNaturally(e.getBlock().getLocation(), cropDrop);
                this.sendMessage(p, this.getItemName() + ": \u00a7r\u00a7aDoubled crops!");
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityDeath(EntityDeathEvent e) {
        LivingEntity entity;
        Player killer;
        if (this.random.nextDouble() < 0.2 && (killer = (entity = e.getEntity()).getKiller()) != null) {
            ItemStack weapon = killer.getInventory().getItemInMainHand();
            int lootingLevel = weapon.getEnchantmentLevel(Enchantment.LOOTING);
            List drops = e.getDrops();
            ArrayList<ItemStack> doubledDrops = new ArrayList<ItemStack>();
            for (ItemStack drop : drops) {
                int baseAmount = drop.getAmount();
                int extra = lootingLevel > 0 ? this.random.nextInt(lootingLevel + 1) : 0;
                int newAmount = baseAmount * 2 + extra;
                ItemStack doubledDrop = new ItemStack(drop.getType(), newAmount);
                doubledDrops.add(doubledDrop);
            }
            drops.clear();
            drops.addAll(doubledDrops);
            this.sendMessage(killer, this.getItemName() + ": \u00a7r\u00a7aDoubled drops!");
        }
    }
}

