/*
 * Decompiled with CFR 0.152.
 */
package dev.j3fftw.headlimiter;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import dev.j3fftw.headlimiter.bstats.Metrics;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.cscorelib2.updater.GitHubBuildsUpdater;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class HeadLimiter
extends JavaPlugin
implements Listener {
    private final ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("HeadLimiter-pool-%d").build();
    private final ExecutorService executorService = Executors.newFixedThreadPool(this.getConfig().getInt("thread-pool-size", 4), this.threadFactory);

    public void onEnable() {
        if (!new File(this.getDataFolder(), "config.yml").exists()) {
            this.saveDefaultConfig();
        }
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        new Metrics((Plugin)this, 9968);
        if (this.getConfig().getBoolean("auto-update") && this.getDescription().getVersion().startsWith("DEV - ")) {
            new GitHubBuildsUpdater((Plugin)this, this.getFile(), "J3fftw1/HeadLimiter/master").start();
        }
    }

    private boolean isCargo(SlimefunItem sfItem) {
        return sfItem.isItem((ItemStack)SlimefunItems.CARGO_INPUT_NODE) || sfItem.isItem((ItemStack)SlimefunItems.CARGO_OUTPUT_NODE) || sfItem.isItem((ItemStack)SlimefunItems.CARGO_OUTPUT_NODE_2) || sfItem.isItem((ItemStack)SlimefunItems.CARGO_CONNECTOR_NODE) || sfItem.isItem((ItemStack)SlimefunItems.CARGO_MANAGER);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlace(BlockPlaceEvent e) {
        SlimefunItem sfItem = SlimefunItem.getByItem((ItemStack)e.getItemInHand());
        if (!e.isCancelled() && (e.getBlock().getType() == Material.PLAYER_HEAD || e.getBlock().getType() == Material.PLAYER_WALL_HEAD) && sfItem != null && this.isCargo(sfItem)) {
            Block block = e.getBlock();
            BlockState[] te = block.getChunk().getTileEntities();
            this.executorService.submit(() -> {
                int i = 0;
                for (BlockState bs : te) {
                    SlimefunItem slimefunItem = BlockStorage.check((Location)bs.getLocation());
                    if (slimefunItem == null || !this.isCargo(slimefunItem)) continue;
                    ++i;
                }
                int threshold = this.getConfig().getInt("amount");
                if (i >= threshold) {
                    Bukkit.getScheduler().runTask((Plugin)this, () -> {
                        if (block.getType() != Material.AIR) {
                            block.setType(Material.AIR);
                            if (!e.getPlayer().getGameMode().equals((Object)GameMode.CREATIVE)) {
                                block.getWorld().dropItemNaturally(block.getLocation(), sfItem.getItem());
                            }
                        }
                    });
                    BlockStorage.clearBlockInfo((Location)block.getLocation());
                    e.getPlayer().sendMessage(ChatColor.RED + "You hit the limit of Cargo nodes in this chunk");
                }
            });
        }
    }
}

