/*
 * Decompiled with CFR 0.152.
 */
package dev.j3fftw.headlimiter.blocklimiter;

import com.google.common.base.Objects;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class Group {
    private final String groupName;
    private final int defaultAmount;
    private final HashSet<String> items;
    private final HashMap<String, Integer> permissionAmounts;

    public Group(ConfigurationSection configurationSection) {
        this.groupName = configurationSection.getName();
        this.defaultAmount = configurationSection.getInt("items-amount", 0);
        this.items = new HashSet(configurationSection.getStringList("items"));
        this.permissionAmounts = new HashMap();
        ConfigurationSection permissionSection = configurationSection.getConfigurationSection("permission-amount");
        if (permissionSection != null) {
            for (String key : permissionSection.getKeys(false)) {
                this.permissionAmounts.put(key, permissionSection.getInt(key, 0));
            }
        }
    }

    public String getGroupName() {
        return this.groupName;
    }

    public int getDefaultAmount() {
        return this.defaultAmount;
    }

    public Set<String> getItems() {
        return this.items;
    }

    public Map<String, Integer> getPermissionAmounts() {
        return this.permissionAmounts;
    }

    public boolean contains(@Nonnull SlimefunItem slimefunItem) {
        return this.contains(slimefunItem.getId());
    }

    public boolean contains(@Nonnull String itemId) {
        return this.items.contains(itemId);
    }

    public int getPermissibleAmount(@Nonnull Player player) {
        int allowable = this.defaultAmount;
        if (!this.permissionAmounts.isEmpty()) {
            for (Map.Entry<String, Integer> entry : this.permissionAmounts.entrySet()) {
                String permission = entry.getKey();
                if (!player.hasPermission(permission)) continue;
                allowable = Math.max(entry.getValue(), allowable);
            }
        }
        return allowable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Group group = (Group)o;
        return this.defaultAmount == group.defaultAmount && Objects.equal((Object)this.groupName, (Object)group.groupName) && Objects.equal(this.items, group.items) && Objects.equal(this.permissionAmounts, group.permissionAmounts);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.groupName, this.defaultAmount, this.items, this.permissionAmounts});
    }
}

