/*
 * Decompiled with CFR 0.152.
 */
package dev.j3fftw.headlimiter.blocklimiter;

import dev.j3fftw.headlimiter.blocklimiter.BlockLimiter;
import dev.j3fftw.headlimiter.blocklimiter.Group;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class ChunkContent {
    private final Map<String, Integer> contentMap = new HashMap<String, Integer>();

    public int getCurrentAmount(@Nonnull SlimefunItem slimefunItem) {
        return this.getCurrentAmount(slimefunItem.getId());
    }

    public int getCurrentAmount(@Nonnull String itemId) {
        return this.contentMap.getOrDefault(itemId, 0);
    }

    public int getGroupTotal(@Nonnull SlimefunItem slimefunItem) {
        return this.getGroupTotal(slimefunItem.getId());
    }

    public int getGroupTotal(@Nonnull String itemId) {
        Set<Group> groupSet = BlockLimiter.getInstance().getGroups();
        for (Group group : groupSet) {
            if (!group.contains(itemId)) continue;
            int amount = 0;
            for (String item : group.getItems()) {
                amount += this.getCurrentAmount(item);
            }
            return amount;
        }
        return -1;
    }

    public void incrementAmount(@Nonnull SlimefunItem slimefunItem) {
        this.incrementAmount(slimefunItem.getId());
    }

    public void incrementAmount(@Nonnull String itemId) {
        int amount = this.getCurrentAmount(itemId);
        this.setAmount(itemId, amount + 1);
    }

    public void decrementAmount(@Nonnull SlimefunItem slimefunItem) {
        this.incrementAmount(slimefunItem.getId());
    }

    public void decrementAmount(@Nonnull String itemId) {
        int amount = this.getCurrentAmount(itemId);
        this.setAmount(itemId, Math.max(0, amount - 1));
    }

    public void setAmount(@Nonnull SlimefunItem slimefunItem, int amount) {
        this.setAmount(slimefunItem.getId(), amount);
    }

    public void setAmount(@Nonnull String itemId, int amount) {
        this.contentMap.put(itemId, amount);
    }
}

