/*
 * Decompiled with CFR 0.152.
 */
package dev.j3fftw.headlimiter.blocklimiter;

import com.google.common.base.Preconditions;
import dev.j3fftw.headlimiter.HeadLimiter;
import dev.j3fftw.headlimiter.blocklimiter.BlockListener;
import dev.j3fftw.headlimiter.blocklimiter.ChunkContent;
import dev.j3fftw.headlimiter.blocklimiter.Group;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.libraries.dough.blocks.ChunkPosition;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public final class BlockLimiter {
    private static BlockLimiter instance;
    private final HashSet<Group> groups = new HashSet();
    private final Map<ChunkPosition, ChunkContent> contentMap = new HashMap<ChunkPosition, ChunkContent>();

    public BlockLimiter(@Nonnull HeadLimiter headLimiter) {
        Preconditions.checkArgument((instance == null ? 1 : 0) != 0, (Object)"Cannot create a new instance of the BlockLimiter");
        instance = this;
        new BlockListener(headLimiter);
        headLimiter.getServer().getScheduler().runTaskLater((Plugin)headLimiter, this::loadBlockStorage, 1L);
    }

    private void loadBlockStorage() {
        for (World world : Bukkit.getWorlds()) {
            BlockStorage worldStorage = BlockStorage.getStorage((World)world);
            if (worldStorage == null) {
                return;
            }
            for (Map.Entry entry : worldStorage.getRawStorage().entrySet()) {
                Location location = (Location)entry.getKey();
                String id = ((Config)entry.getValue()).getString("id");
                ChunkPosition chunkPosition = new ChunkPosition(location.getChunk());
                ChunkContent content = this.contentMap.get(chunkPosition);
                if (content == null) {
                    content = new ChunkContent();
                    content.incrementAmount(id);
                    this.contentMap.put(chunkPosition, content);
                    continue;
                }
                content.incrementAmount(id);
            }
        }
    }

    @Nullable
    public ChunkContent getChunkContent(@Nonnull ChunkPosition chunkPosition) {
        return this.contentMap.get(chunkPosition);
    }

    public Group getGroupByItem(@Nonnull SlimefunItem slimefunItem) {
        return this.getGroupByItem(slimefunItem.getId());
    }

    @Nullable
    public Group getGroupByItem(@Nonnull String itemId) {
        for (Group group : this.groups) {
            if (!group.contains(itemId)) continue;
            return group;
        }
        return null;
    }

    public int getPlayerLimitByItem(@Nonnull Player player, @Nonnull SlimefunItem slimefunItem) {
        return this.getPlayerLimitByItem(player, slimefunItem.getId());
    }

    public int getPlayerLimitByItem(@Nonnull Player player, @Nonnull String itemId) {
        Group group = this.getGroupByItem(itemId);
        if (group == null) {
            return -1;
        }
        return group.getPermissibleAmount(player);
    }

    public Set<Group> getGroups() {
        return this.groups;
    }

    public void setChunkContent(@Nonnull ChunkPosition chunkPosition, @Nonnull ChunkContent content) {
        this.contentMap.put(chunkPosition, content);
    }

    @Nonnull
    public static BlockLimiter getInstance() {
        return instance;
    }
}

