/*
 * Decompiled with CFR 0.152.
 */
package dev.j3fftw.headlimiter;

import dev.j3fftw.headlimiter.CountCommand;
import dev.j3fftw.headlimiter.MetricsService;
import dev.j3fftw.headlimiter.Utils;
import dev.j3fftw.headlimiter.blocklimiter.BlockLimiter;
import dev.j3fftw.headlimiter.blocklimiter.Group;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.libraries.dough.updater.GitHubBuildsUpdater;
import java.io.File;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class HeadLimiter
extends JavaPlugin
implements Listener {
    private static HeadLimiter instance;
    private BlockLimiter blockLimiter;

    public void onEnable() {
        instance = this;
        if (!new File(this.getDataFolder(), "config.yml").exists()) {
            this.saveDefaultConfig();
        }
        Utils.loadPermissions();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("headlimiter").setExecutor((CommandExecutor)new CountCommand());
        new MetricsService(this).start();
        if (this.getConfig().getBoolean("auto-update", true) && this.getDescription().getVersion().startsWith("DEV - ")) {
            new GitHubBuildsUpdater((Plugin)this, this.getFile(), "J3fftw1/HeadLimiter/master").start();
        }
        this.blockLimiter = new BlockLimiter(this);
        this.loadConfig();
    }

    public void onDisable() {
        instance = null;
    }

    public boolean isCargo(SlimefunItem sfItem) {
        return sfItem.isItem((ItemStack)SlimefunItems.CARGO_INPUT_NODE) || sfItem.isItem((ItemStack)SlimefunItems.CARGO_OUTPUT_NODE) || sfItem.isItem((ItemStack)SlimefunItems.CARGO_OUTPUT_NODE_2) || sfItem.isItem((ItemStack)SlimefunItems.CARGO_CONNECTOR_NODE) || sfItem.isItem((ItemStack)SlimefunItems.CARGO_MANAGER);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlace(BlockPlaceEvent e) {
        SlimefunItem sfItem;
        Player player = e.getPlayer();
        Block block = e.getBlock();
        if (!(e.isCancelled() || block.getType() != Material.PLAYER_HEAD && block.getType() != Material.PLAYER_WALL_HEAD || Utils.canBypass(player) || (sfItem = SlimefunItem.getByItem((ItemStack)e.getItemInHand())) == null || !this.isCargo(sfItem))) {
            int maxAmount = Utils.getMaxHeads(player);
            Utils.count(block.getChunk(), result -> Utils.onCheck(player, block, maxAmount, result.getTotal(), sfItem));
        }
    }

    public BlockLimiter getBlockLimiter() {
        return this.blockLimiter;
    }

    public static HeadLimiter getInstance() {
        return instance;
    }

    public void loadConfig() {
        ConfigurationSection configurationSection = instance.getConfig().getConfigurationSection("block-limits");
        if (configurationSection == null) {
            throw new IllegalStateException("No configuration for groups is available.");
        }
        for (String key : configurationSection.getKeys(false)) {
            BlockLimiter.getInstance().getGroups().add(new Group(configurationSection.getConfigurationSection(key)));
        }
    }
}

