/*
 * Decompiled with CFR 0.152.
 */
package dev.j3fftw.headlimiter.blocklimiter;

import dev.j3fftw.headlimiter.HeadLimiter;
import dev.j3fftw.headlimiter.blocklimiter.BlockLimiter;
import dev.j3fftw.headlimiter.blocklimiter.ChunkContent;
import io.github.thebusybiscuit.slimefun4.api.events.SlimefunBlockBreakEvent;
import io.github.thebusybiscuit.slimefun4.api.events.SlimefunBlockPlaceEvent;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.libraries.dough.blocks.ChunkPosition;
import javax.annotation.Nonnull;
import org.bukkit.ChatColor;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class BlockListener
implements Listener {
    public BlockListener(@Nonnull HeadLimiter headLimiter) {
        headLimiter.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)headLimiter);
    }

    @EventHandler
    public void onSlimefunItemPlaced(@Nonnull SlimefunBlockPlaceEvent event) {
        SlimefunItem slimefunItem = event.getSlimefunItem();
        String slimefunItemId = slimefunItem.getId();
        int definedLimit = BlockLimiter.getInstance().getPlayerLimitByItem(event.getPlayer(), slimefunItem);
        if (definedLimit == -1) {
            return;
        }
        ChunkPosition chunkPosition = new ChunkPosition(event.getBlockPlaced().getChunk());
        ChunkContent content = BlockLimiter.getInstance().getChunkContent(chunkPosition);
        if (content == null) {
            content = new ChunkContent();
            content.incrementAmount(slimefunItemId);
            BlockLimiter.getInstance().setChunkContent(chunkPosition, content);
        } else if (content.getGroupTotal(slimefunItemId) < definedLimit) {
            content.incrementAmount(slimefunItemId);
        } else {
            event.setCancelled(true);
            event.getPlayer().sendMessage(ChatColor.RED + "You cannot place any more of this item within this chunk.");
        }
    }

    @EventHandler
    public void onSlimefunItemBroken(@Nonnull SlimefunBlockBreakEvent event) {
        SlimefunItem slimefunItem = event.getSlimefunItem();
        String slimefunItemId = slimefunItem.getId();
        int definedLimit = BlockLimiter.getInstance().getPlayerLimitByItem(event.getPlayer(), slimefunItem);
        if (definedLimit == -1) {
            return;
        }
        ChunkPosition chunkPosition = new ChunkPosition(event.getBlockBroken().getChunk());
        ChunkContent content = BlockLimiter.getInstance().getChunkContent(chunkPosition);
        if (content == null) {
            return;
        }
        content.decrementAmount(slimefunItemId);
    }
}

