/*
 * Decompiled with CFR 0.152.
 */
package tsp.helperlite.command.argument;

import com.google.common.reflect.TypeToken;
import java.util.Optional;
import javax.annotation.Nonnull;
import tsp.helperlite.Commands;
import tsp.helperlite.command.CommandInterruptException;
import tsp.helperlite.command.argument.ArgumentParser;

public interface Argument {
    public int index();

    @Nonnull
    public Optional<String> value();

    @Nonnull
    default public <T> Optional<T> parse(@Nonnull ArgumentParser<T> parser) {
        return parser.parse(this);
    }

    @Nonnull
    default public <T> T parseOrFail(@Nonnull ArgumentParser<T> parser) throws CommandInterruptException {
        return parser.parseOrFail(this);
    }

    @Nonnull
    default public <T> Optional<T> parse(@Nonnull TypeToken<T> type) {
        return Commands.parserRegistry().find(type).flatMap(this::parse);
    }

    @Nonnull
    default public <T> T parseOrFail(@Nonnull TypeToken<T> type) throws CommandInterruptException {
        ArgumentParser parser = Commands.parserRegistry().find(type).orElse(null);
        if (parser == null) {
            throw new RuntimeException("Unable to find ArgumentParser for " + type);
        }
        return this.parseOrFail(parser);
    }

    @Nonnull
    default public <T> Optional<T> parse(@Nonnull Class<T> clazz) {
        return Commands.parserRegistry().find(clazz).flatMap(this::parse);
    }

    @Nonnull
    default public <T> T parseOrFail(@Nonnull Class<T> clazz) throws CommandInterruptException {
        ArgumentParser parser = Commands.parserRegistry().find(clazz).orElse(null);
        if (parser == null) {
            throw new RuntimeException("Unable to find ArgumentParser for " + clazz);
        }
        return this.parseOrFail(parser);
    }

    public boolean isPresent();

    default public void assertPresent() throws CommandInterruptException {
        CommandInterruptException.makeAssertion(this.isPresent(), "&cArgument at index " + this.index() + " is not present.");
    }
}

