/*
 * Decompiled with CFR 0.152.
 */
package tsp.headdb.core.storage;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import tsp.headdb.HeadDB;
import tsp.headdb.core.storage.PlayerData;
import tsp.headdb.core.storage.Storage;
import tsp.warehouse.storage.file.SerializableFileDataManager;

public class PlayerStorage
extends SerializableFileDataManager<HashSet<PlayerData>> {
    private final Map<UUID, PlayerData> players = new HashMap<UUID, PlayerData>();

    public PlayerStorage(HeadDB instance, Storage storage) {
        super(new File(instance.getDataFolder(), "data/players.data"), storage.getExecutor());
    }

    public void set(PlayerData data) {
        this.players.put(data.uniqueId(), data);
    }

    public Set<String> getFavorites(UUID uuid) {
        return this.players.containsKey(uuid) ? this.players.get(uuid).favorites() : new HashSet<String>();
    }

    public void addFavorite(UUID uuid, String texture) {
        Set<String> fav = this.getFavorites(uuid);
        fav.add(texture);
        this.players.put(uuid, new PlayerData(uuid, new HashSet<String>(fav)));
    }

    public void removeFavorite(UUID uuid, String texture) {
        Set<String> fav = this.getFavorites(uuid);
        fav.remove(texture);
        this.players.put(uuid, new PlayerData(uuid, new HashSet<String>(fav)));
    }

    public Optional<PlayerData> get(UUID uuid) {
        return Optional.ofNullable(this.players.get(uuid));
    }

    public Map<UUID, PlayerData> getPlayersMap() {
        return Collections.unmodifiableMap(this.players);
    }

    public void init() {
        this.load().whenComplete((data, ex) -> {
            for (PlayerData entry : data.orElse(new HashSet())) {
                this.players.put(entry.uniqueId(), entry);
            }
            HeadDB.getInstance().getLog().debug("Loaded " + this.players.values().size() + " player data!");
        });
    }

    public void backup() {
        this.save(new HashSet<PlayerData>(this.players.values())).whenComplete((success, ex) -> HeadDB.getInstance().getLog().debug("Saved " + this.players.values().size() + " player data!"));
    }

    public void suspend() {
        Boolean saved = (Boolean)((CompletableFuture)this.save(new HashSet<PlayerData>(this.players.values())).exceptionally(ex -> {
            HeadDB.getInstance().getLog().error("Failed to save player data! | Stack Trace: ");
            ex.printStackTrace();
            return false;
        })).join();
        if (Boolean.TRUE.equals(saved)) {
            HeadDB.getInstance().getLog().debug("Saved " + this.players.values().size() + " player data!");
        }
    }
}

