/*
 * Decompiled with CFR 0.152.
 */
package tsp.nexuslib.task;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;
import tsp.nexuslib.util.Validate;

public interface Task
extends Runnable {
    default public Duration getDelay() {
        return Duration.ofMillis(-1L);
    }

    default public Duration getRepeatInterval() {
        return Duration.ofMillis(-1L);
    }

    default public long getDelayTicks() {
        return this.getDelay().toSeconds() * 20L;
    }

    default public long getRepeatIntervalTicks() {
        return this.getRepeatInterval().toSeconds() * 20L;
    }

    default public boolean isAsync() {
        return false;
    }

    @Nonnull
    default public BukkitTask schedule(@Nonnull JavaPlugin plugin) {
        Validate.notNull(plugin, "Plugin must not be null!");
        BukkitScheduler scheduler = plugin.getServer().getScheduler();
        long repeat = this.getRepeatIntervalTicks();
        long delay = this.getDelayTicks();
        if (this.isAsync()) {
            if (repeat > -1L && delay > -1L) {
                return scheduler.runTaskTimerAsynchronously((Plugin)plugin, (Runnable)this, delay, repeat);
            }
            if (repeat > -1L) {
                return scheduler.runTaskTimerAsynchronously((Plugin)plugin, (Runnable)this, 0L, repeat);
            }
            if (delay > -1L) {
                return scheduler.runTaskLaterAsynchronously((Plugin)plugin, (Runnable)this, delay);
            }
            return scheduler.runTaskAsynchronously((Plugin)plugin, (Runnable)this);
        }
        if (repeat > -1L && delay > -1L) {
            return scheduler.runTaskTimer((Plugin)plugin, (Runnable)this, delay, repeat);
        }
        if (repeat > -1L) {
            return scheduler.runTaskTimer((Plugin)plugin, (Runnable)this, 0L, repeat);
        }
        if (delay > -1L) {
            return scheduler.runTaskLater((Plugin)plugin, (Runnable)this, delay);
        }
        return scheduler.runTask((Plugin)plugin, (Runnable)this);
    }

    @Nonnull
    public static List<BukkitTask> schedule(@Nonnull JavaPlugin plugin, Task ... tasks) {
        Validate.notNull(plugin, "Plugin must not be null!");
        Validate.notNull(tasks, "Tasks must not be null!");
        ArrayList<BukkitTask> result = new ArrayList<BukkitTask>();
        for (Task task : tasks) {
            result.add(task.schedule(plugin));
        }
        return result;
    }
}

