/*
 * Decompiled with CFR 0.152.
 */
package tsp.nexuslib.inventory;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import tsp.nexuslib.inventory.Button;
import tsp.nexuslib.inventory.Page;
import tsp.nexuslib.inventory.Pane;
import tsp.nexuslib.util.Validate;

public class PagedPane
extends Pane {
    private final Inventory inventory;
    private final SortedMap<Integer, Page> pages = new TreeMap<Integer, Page>();
    private int currentIndex;
    private final int pageSize;
    private ItemStack borderItem;
    private ItemStack backItem;
    private ItemStack nextItem;
    private ItemStack currentItem;
    private Button controlBack;
    private Button controlNext;
    private Button controlCurrent;

    public PagedPane(int pageSize, int rows, @Nonnull String title) {
        super(rows, title);
        if (rows > 6) {
            throw new IllegalArgumentException("Rows must be <= 6, got " + rows);
        }
        if (pageSize > 6) {
            throw new IllegalArgumentException("Page size must be <= 6, got" + pageSize);
        }
        this.borderItem = new ItemStack(Material.BLACK_STAINED_GLASS_PANE);
        this.backItem = new ItemStack(Material.ARROW);
        this.nextItem = new ItemStack(Material.ARROW);
        this.currentItem = new ItemStack(Material.BOOK);
        this.pageSize = pageSize;
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)(rows * 9), (String)this.color(title));
        this.pages.put(0, new Page(pageSize));
    }

    @Override
    public void addButton(@Nonnull Button button) {
        Validate.notNull(button, "Button must not be null!");
        for (Map.Entry<Integer, Page> entry : this.pages.entrySet()) {
            if (!entry.getValue().addButton(button)) continue;
            if (entry.getKey() == this.currentIndex) {
                this.reRender();
            }
            return;
        }
        Page page = new Page(this.pageSize);
        page.addButton(button);
        this.pages.put(this.pages.lastKey() + 1, page);
        this.reRender();
    }

    @Override
    public void setButton(int i, @Nonnull Button button) {
        Validate.notNull(button, "Button must not be null!");
        for (Map.Entry<Integer, Page> entry : this.pages.entrySet()) {
            if (!entry.getValue().setButton(i, button)) continue;
            if (entry.getKey() == this.currentIndex) {
                this.reRender();
            }
            return;
        }
        Page page = new Page(this.pageSize);
        page.setButton(i, button);
        this.pages.put(this.pages.lastKey() + 1, page);
        this.reRender();
    }

    @Override
    public void removeButton(@Nonnull Button button) {
        Validate.notNull(button, "Button must not be null!");
        Iterator<Map.Entry<Integer, Page>> iterator = this.pages.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, Page> entry = iterator.next();
            if (!entry.getValue().removeButton(button)) continue;
            if (entry.getValue().isEmpty()) {
                if (this.pages.size() > 1) {
                    iterator.remove();
                }
                if (this.currentIndex >= this.pages.size()) {
                    --this.currentIndex;
                }
            }
            if (entry.getKey() >= this.currentIndex) {
                this.reRender();
            }
            return;
        }
    }

    public int getPageAmount() {
        return this.pages.size();
    }

    public int getCurrentPage() {
        return this.currentIndex + 1;
    }

    public void selectPage(int index) {
        if (index < 0 || index >= this.getPageAmount()) {
            throw new IllegalArgumentException("Index out of bounds s: " + index + " [0 " + this.getPageAmount() + ")");
        }
        if (index == this.currentIndex) {
            return;
        }
        this.currentIndex = index;
        this.reRender();
    }

    @Override
    public void reRender() {
        this.inventory.clear();
        ((Page)this.pages.get(this.currentIndex)).render(this.inventory);
        this.controlBack = null;
        this.controlNext = null;
        this.createControls(this.inventory);
    }

    @Override
    public void onClick(InventoryClickEvent event) {
        event.setCancelled(true);
        if (event.getRawSlot() == this.inventory.getSize() - 8) {
            if (this.controlBack != null) {
                this.controlBack.onClick(event);
            }
        } else if (event.getRawSlot() == this.inventory.getSize() - 2) {
            if (this.controlNext != null) {
                this.controlNext.onClick(event);
            }
        } else if (event.getRawSlot() == this.inventory.getSize() - 5) {
            if (this.controlCurrent != null) {
                this.controlCurrent.onClick(event);
            }
        } else {
            ((Page)this.pages.get(this.currentIndex)).handleClick(event);
        }
    }

    @Override
    @Nonnull
    public Inventory getInventory() {
        return this.inventory;
    }

    public SortedMap<Integer, Page> getPages() {
        return this.pages;
    }

    public Page getPage(int index) {
        return (Page)this.pages.get(index);
    }

    private void createControls(Inventory inventory) {
        ItemStack itemStack;
        String lore;
        String name;
        this.fillRow(inventory.getSize() / 9 - 2, this.borderItem, inventory);
        if (this.getCurrentPage() > 1) {
            name = String.format(Locale.ROOT, "&3&lPage &a&l%d &7/ &c&l%d", this.getCurrentPage() - 1, this.getPageAmount());
            lore = String.format(Locale.ROOT, "&7Brings you back to the page &c%d", this.getCurrentPage() - 1);
            itemStack = this.getItemStack(this.backItem, name, lore);
            this.controlBack = new Button(itemStack, event -> this.selectPage(this.currentIndex - 1));
            inventory.setItem(inventory.getSize() - 8, itemStack);
        }
        if (this.getCurrentPage() < this.getPageAmount()) {
            name = String.format(Locale.ROOT, "&3&lPage &a&l%d &7/ &c&l%d", this.getCurrentPage() + 1, this.getPageAmount());
            lore = String.format(Locale.ROOT, "&7Brings you to the page &c%d", this.getCurrentPage() + 1);
            itemStack = this.getItemStack(this.nextItem, name, lore);
            this.controlNext = new Button(itemStack, event -> this.selectPage(this.getCurrentPage()));
            inventory.setItem(inventory.getSize() - 2, itemStack);
        }
        name = String.format(Locale.ROOT, "&3&lPage &a&l%d &7/ &c&l%d", this.getCurrentPage(), this.getPageAmount());
        lore = String.format(Locale.ROOT, "&7You are on page &a%d &7/ &c%d", this.getCurrentPage(), this.getPageAmount());
        itemStack = this.getItemStack(this.currentItem, name, lore);
        inventory.setItem(inventory.getSize() - 5, itemStack);
    }

    private void fillRow(int rowIndex, @Nonnull ItemStack itemStack, @Nonnull Inventory inventory) {
        int yMod = rowIndex * 9;
        for (int i = 0; i < 9; ++i) {
            int slot = yMod + i;
            inventory.setItem(slot, itemStack);
        }
    }

    private ItemStack getItemStack(@Nonnull ItemStack item, @Nullable String name, String ... lore) {
        Validate.notNull(item, "Item must not be null!");
        ItemMeta itemMeta = item.getItemMeta();
        if (name != null) {
            itemMeta.setDisplayName(this.color(name));
        }
        if (lore != null && lore.length != 0) {
            itemMeta.setLore(Arrays.stream(lore).map(this::color).collect(Collectors.toList()));
        }
        item.setItemMeta(itemMeta);
        return item;
    }

    private String color(String input) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)input);
    }

    @Override
    public void open(Player player) {
        this.reRender();
        player.openInventory(this.getInventory());
    }

    public void setBorderItem(@Nonnull ItemStack item) {
        Validate.notNull(item, "Item must not be null!");
        this.borderItem = item;
    }

    public void setControlCurrent(Button controlCurrent) {
        this.controlCurrent = controlCurrent;
    }

    public void setCurrentItem(@Nonnull ItemStack item) {
        Validate.notNull(item, "Item must not be null!");
        this.currentItem = item;
    }

    public void setBackItem(@Nonnull ItemStack item) {
        Validate.notNull(item, "Item must not be null!");
        this.backItem = item;
    }

    public void setNextItem(@Nonnull ItemStack item) {
        Validate.notNull(item, "Item must not be null!");
        this.nextItem = item;
    }

    public ItemStack getBorderItem() {
        return this.borderItem;
    }

    public ItemStack getCurrentItem() {
        return this.currentItem;
    }

    public ItemStack getBackItem() {
        return this.backItem;
    }

    public ItemStack getNextItem() {
        return this.nextItem;
    }
}

