/*
 * Decompiled with CFR 0.152.
 */
package tsp.nexuslib.inventory;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import tsp.nexuslib.inventory.Button;
import tsp.nexuslib.util.Validate;

public class Page {
    private final Map<Integer, Button> buttons = new HashMap<Integer, Button>();
    private final int maxSize;

    public Page(int maxSize) {
        this.maxSize = maxSize;
    }

    public void handleClick(@Nonnull InventoryClickEvent event) {
        Validate.notNull(event, "InventoryClickEvent must not be null!");
        if (event.getRawSlot() > event.getInventory().getSize()) {
            return;
        }
        if (event.getSlotType() == InventoryType.SlotType.OUTSIDE) {
            return;
        }
        if (event.getSlot() >= this.buttons.size()) {
            return;
        }
        Button button = this.buttons.get(event.getSlot());
        if (button != null) {
            button.onClick(event);
        }
    }

    public boolean hasSpace() {
        return this.buttons.size() < this.maxSize * 9;
    }

    public boolean addButton(@Nonnull Button button) {
        Validate.notNull(button, "Button must not be null!");
        if (!this.hasSpace()) {
            return false;
        }
        this.buttons.put(this.buttons.size(), button);
        return true;
    }

    public boolean setButton(int i, @Nonnull Button button) {
        Validate.notNull(button, "Button must not be null!");
        this.buttons.put(i, button);
        return true;
    }

    public boolean removeButton(@Nonnull Button button) {
        Validate.notNull(button, "Button must not be null!");
        Map.Entry<Integer, Button> match = null;
        for (Map.Entry<Integer, Button> entry : this.buttons.entrySet()) {
            if (!entry.getValue().equals(button)) continue;
            match = entry;
            break;
        }
        return match != null && this.buttons.remove(match.getKey(), match.getValue());
    }

    public void render(@Nonnull Inventory inventory) {
        Validate.notNull(inventory, "Inventory must not be null!");
        for (Map.Entry<Integer, Button> button : this.buttons.entrySet()) {
            inventory.setItem(button.getKey().intValue(), button.getValue().getItemStack());
        }
    }

    public boolean isEmpty() {
        return this.buttons.isEmpty();
    }
}

