/*
 * Decompiled with CFR 0.152.
 */
package tsp.nexuslib.util;

import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;
import tsp.nexuslib.NexusPlugin;
import tsp.nexuslib.persistence.PersistentDataAPI;

public final class ItemUtils {
    public static final NamespacedKey COOLDOWN_KEY = new NamespacedKey((Plugin)NexusPlugin.getInstance(), "item_cooldown");
    public static final NamespacedKey LAST_USED_KEY = new NamespacedKey((Plugin)NexusPlugin.getInstance(), "item_lastused");

    private ItemUtils() {
    }

    public static Optional<ItemMeta> getMeta(ItemStack item) {
        return Optional.ofNullable(item.getItemMeta());
    }

    public static Optional<String> getDisplayName(ItemStack item) {
        return ItemUtils.getMeta(item).map(meta -> meta.hasDisplayName() ? meta.getDisplayName() : null);
    }

    public static Optional<String> getLocalizedName(ItemStack item) {
        return ItemUtils.getMeta(item).map(meta -> meta.hasLocalizedName() ? meta.getLocalizedName() : null);
    }

    public static void setCooldown(@Nonnull ItemStack item, long time) {
        if (time > -1L) {
            ItemMeta meta = item.getItemMeta();
            if (meta == null) {
                throw new IllegalStateException("Item does not have meta: " + item.getType().name());
            }
            PersistentDataAPI.setLong((PersistentDataHolder)meta, COOLDOWN_KEY, time);
            PersistentDataAPI.setLong((PersistentDataHolder)meta, LAST_USED_KEY, System.currentTimeMillis());
            item.setItemMeta(meta);
        }
    }

    public static long getTimeLeft(@Nonnull ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            throw new IllegalStateException("Item does not have meta: " + item.getType().name());
        }
        long l = PersistentDataAPI.getLong((PersistentDataHolder)meta, LAST_USED_KEY, -1L);
        long time = PersistentDataAPI.getLong((PersistentDataHolder)meta, COOLDOWN_KEY, -1L);
        if (l < 1L || time < 1L) {
            return -1L;
        }
        return (l + time * 1000L - System.currentTimeMillis()) / 1000L;
    }

    public static void use(@Nonnull ItemStack item, long cooldown, @Nonnull Consumer<Long> ready, @Nonnull Consumer<Long> timeleft) {
        long time = ItemUtils.getTimeLeft(item);
        if (time < 1L) {
            ready.accept(cooldown);
            ItemUtils.setCooldown(item, cooldown);
        } else {
            timeleft.accept(time);
        }
    }

    public static void use(@Nonnull ItemStack item, long cooldown) {
        long time = ItemUtils.getTimeLeft(item);
        if (time < 1L) {
            ItemUtils.setCooldown(item, cooldown);
        }
    }
}

