/*
 * Decompiled with CFR 0.152.
 */
package tsp.headdb.core.command;

import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import tsp.headdb.HeadDB;
import tsp.headdb.core.command.SubCommand;
import tsp.headdb.core.util.Utils;

public class CommandLanguage
extends SubCommand {
    public CommandLanguage() {
        super("language", HeadDB.getInstance().getLocalization().getData().keySet(), "l", "lang");
    }

    @Override
    public void handle(CommandSender sender, String[] args) {
        if (args.length < 2) {
            this.getLocalization().sendMessage(sender, "invalidArguments");
            return;
        }
        String lang = args[1];
        if (!this.getLocalization().getData().containsKey(lang)) {
            this.getLocalization().sendMessage(sender, "invalidLanguage", msg -> msg.replace("%languages%", Utils.toString(this.getLocalization().getData().keySet())));
            return;
        }
        if (!(sender instanceof Player)) {
            this.getLocalization().setConsoleLanguage(lang);
        } else {
            Player player = (Player)sender;
            this.getLocalization().setLanguage(player.getUniqueId(), lang);
        }
        this.getLocalization().sendMessage(sender, "languageChanged", msg -> msg.replace("%language%", lang));
    }
}

