/*
 * Decompiled with CFR 0.152.
 */
package tsp.warehouse.storage.file;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import tsp.warehouse.storage.file.FileDataManager;

public class SerializableFileDataManager<Serializable>
extends FileDataManager<Serializable> {
    public SerializableFileDataManager(@Nonnull File file, @Nullable Executor executor) {
        super(file, executor);
    }

    @Override
    public CompletableFuture<Optional<Serializable>> load() {
        this.createFileIfNotExist();
        return CompletableFuture.supplyAsync(() -> {
            try (ObjectInputStream in = new ObjectInputStream(new FileInputStream(this.getFile()));){
                Optional<Object> optional = Optional.of(in.readObject());
                return optional;
            }
            catch (EOFException emptyEx) {
                return Optional.empty();
            }
            catch (IOException | ClassNotFoundException ex) {
                throw new CompletionException(ex);
            }
        }, this.getExecutor());
    }

    @Override
    public CompletableFuture<Boolean> save(Serializable data) {
        this.createFileIfNotExist();
        return CompletableFuture.supplyAsync(() -> {
            try (ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(this.getFile()));){
                out.writeObject(data);
                Boolean bl = true;
                return bl;
            }
            catch (IOException ex) {
                throw new CompletionException(ex);
            }
        }, this.getExecutor());
    }
}

