/*
 * Decompiled with CFR 0.152.
 */
package tsp.nexuslib.builder;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.material.MaterialData;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import tsp.nexuslib.util.Pair;
import tsp.nexuslib.util.Validate;

public class ItemBuilder {
    private final ItemStack item;
    private ItemMeta meta;
    private boolean colorize = true;

    public ItemBuilder(@Nonnull Material material) {
        Validate.notNull(material, "Material can not be null!");
        this.item = new ItemStack(material);
        this.meta = this.item.getItemMeta();
    }

    public ItemBuilder(@Nonnull ItemStack item) {
        Validate.notNull(item, "Item can not be null!");
        this.item = item;
        this.meta = item.getItemMeta();
    }

    public ItemBuilder(@Nonnull ItemStack item, @Nonnull ItemMeta meta) {
        Validate.notNull(item, "Item can not be null!");
        Validate.notNull(meta, "Meta can not be null!");
        this.item = item;
        this.meta = meta;
    }

    public ItemBuilder(@Nonnull Item item) {
        Validate.notNull(item, "Item can not be null!");
        this.item = item.getItemStack();
        this.meta = item.getItemStack().getItemMeta();
    }

    public ItemBuilder material(Material material) {
        this.item.setType(material);
        return this;
    }

    public ItemBuilder name(@Nonnull String name) {
        Validate.notNull(name, "Name can not be null!");
        this.meta.setDisplayName(this.colorize(name));
        return this;
    }

    public ItemBuilder amount(int amount) {
        this.item.setAmount(amount);
        return this;
    }

    public ItemBuilder enchant(@Nonnull Enchantment enchantment, int level, boolean ignoreLevelRestriction) {
        Validate.notNull(enchantment, "Enchantment can not be null!");
        this.meta.addEnchant(enchantment, level, ignoreLevelRestriction);
        return this;
    }

    public ItemBuilder enchant(@Nonnull Enchantment enchantment, int level) {
        Validate.notNull(enchantment, "Enchantment can not be null!");
        this.meta.addEnchant(enchantment, level, false);
        return this;
    }

    public ItemBuilder enchant(@Nonnull Pair<Enchantment, Integer> enchantment, boolean ignoreRestrictions) {
        Validate.notNull(enchantment, "Enchantment pair can not be null!");
        this.meta.addEnchant(enchantment.key(), enchantment.value().intValue(), ignoreRestrictions);
        return this;
    }

    public ItemBuilder enchant(@Nonnull Pair<Enchantment, Integer> enchantment) {
        Validate.notNull(enchantment, "Enchantment pair can not be null!");
        return this.enchant(enchantment.key(), enchantment.value(), false);
    }

    public ItemBuilder enchant(@Nonnull Map<Enchantment, Integer> enchantments, boolean ignoreLevelRestriction) {
        Validate.notNull(enchantments, "Enchantments can not be null!");
        for (Map.Entry<Enchantment, Integer> enchantment : enchantments.entrySet()) {
            this.meta.addEnchant(enchantment.getKey(), enchantment.getValue().intValue(), ignoreLevelRestriction);
        }
        return this;
    }

    public ItemBuilder disenchant(@Nonnull Enchantment enchantment) {
        Validate.notNull(enchantment, "Enchantment can not be null!");
        this.meta.removeEnchant(enchantment);
        return this;
    }

    public ItemBuilder disenchant(@Nonnull Collection<Enchantment> enchantments) {
        Validate.notNull(enchantments, "Enchantments can not be null!");
        for (Enchantment enchantment : enchantments) {
            this.meta.removeEnchant(enchantment);
        }
        return this;
    }

    public ItemBuilder addLore(@Nonnull String lore) {
        Validate.notNull(lore, "Lore can not be null!");
        List<String> loreList = this.meta.getLore() != null ? this.meta.getLore() : new ArrayList();
        loreList.add(this.colorize(lore));
        this.meta.setLore(loreList);
        return this;
    }

    public ItemBuilder setLore(String ... lore) {
        if (lore == null) {
            this.meta.setLore(null);
        } else {
            this.meta.setLore(Arrays.stream(lore).map(this::colorize).collect(Collectors.toList()));
        }
        return this;
    }

    public ItemBuilder setLore(@Nullable List<String> lore) {
        if (lore == null) {
            this.meta.setLore(null);
        } else {
            this.meta.setLore(lore.stream().map(this::colorize).collect(Collectors.toList()));
        }
        return this;
    }

    public ItemBuilder removeLore(int index) {
        if (this.meta.getLore() != null) {
            List loreList = this.meta.getLore();
            loreList.remove(index);
            this.meta.setLore(loreList);
        }
        return this;
    }

    public ItemBuilder removeLore(@Nonnull String line) {
        Validate.notNull(line, "line can not be null!");
        if (this.meta.getLore() != null) {
            List loreList = this.meta.getLore();
            loreList.remove(line);
            this.meta.setLore(loreList);
        }
        return this;
    }

    public ItemBuilder addItemFlags(ItemFlag ... itemFlags) {
        Validate.notNull(this.item, "ItemFlag can not be null!");
        this.meta.addItemFlags(itemFlags);
        return this;
    }

    public ItemBuilder removeItemFlags(ItemFlag ... itemFlags) {
        Validate.notNull(itemFlags, "ItemFlag can not be null!");
        this.meta.removeItemFlags(itemFlags);
        return this;
    }

    @Deprecated
    public ItemBuilder setMaterialData(@Nonnull MaterialData materialData) {
        Validate.notNull(materialData, "MaterialData can not be null!");
        this.item.setData(materialData);
        return this;
    }

    public ItemBuilder setUnbreakable(boolean unbreakable) {
        this.meta.setUnbreakable(unbreakable);
        return this;
    }

    public ItemBuilder setDurability(int durability) {
        if (!(this.meta instanceof Damageable)) {
            return this;
        }
        ((Damageable)this.meta).setDamage(durability);
        return this;
    }

    public ItemBuilder addAttributeModifier(@Nonnull Attribute attribute, @Nonnull AttributeModifier modifier) {
        Validate.notNull(attribute, "Attribute can not be null!");
        Validate.notNull(modifier, "Modifier can not be null!");
        this.meta.addAttributeModifier(attribute, modifier);
        return this;
    }

    public ItemBuilder setAttributeModifiers(@Nonnull Multimap<Attribute, AttributeModifier> attributes) {
        Validate.notNull(attributes, "Attributes can not be null!");
        this.meta.setAttributeModifiers(attributes);
        return this;
    }

    public ItemBuilder setGlow(boolean glow) {
        if (glow) {
            return this.enchant(this.item.getType() != Material.BOW ? Enchantment.ARROW_INFINITE : Enchantment.LUCK, 1, true);
        }
        return this.disenchant(this.item.getType() != Material.BOW ? Enchantment.ARROW_INFINITE : Enchantment.LUCK);
    }

    public ItemBuilder setOwner(@Nonnull OfflinePlayer owner) {
        Validate.notNull(owner, "Owner can not be null!");
        if (this.meta instanceof SkullMeta) {
            ((SkullMeta)this.meta).setOwningPlayer(owner);
        }
        return this;
    }

    public ItemBuilder setCustomModelData(int i) {
        this.meta.setCustomModelData(Integer.valueOf(i));
        return this;
    }

    public ItemBuilder setItemMeta(@Nonnull ItemMeta meta) {
        Validate.notNull(meta, "Meta can not be null!");
        this.meta = meta;
        return this;
    }

    public <T, Z> ItemBuilder set(NamespacedKey key, PersistentDataType<T, Z> type, Z value) {
        this.getContainer().set(key, type, value);
        return this;
    }

    public <T, Z> ItemBuilder setIfAbsent(NamespacedKey key, PersistentDataType<T, Z> type, Z value) {
        if (!this.getContainer().has(key, type)) {
            this.getContainer().set(key, type, value);
        }
        return this;
    }

    public ItemStack build() {
        this.item.setItemMeta(this.meta);
        return this.item.clone();
    }

    public PersistentDataContainer getContainer() {
        return this.meta.getPersistentDataContainer();
    }

    public ItemBuilder colorize(boolean b) {
        this.colorize = b;
        return this;
    }

    private String colorize(String string) {
        if (!this.colorize) {
            return string;
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)string);
    }
}

