/*
 * Decompiled with CFR 0.152.
 */
package tsp.helperlite.command.argument;

import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import tsp.helperlite.command.CommandInterruptException;
import tsp.helperlite.command.argument.Argument;

@ParametersAreNonnullByDefault
public interface ArgumentParser<T> {
    public static <T> ArgumentParser<T> of(Function<String, Optional<T>> parseFunction) {
        return parseFunction::apply;
    }

    public static <T> ArgumentParser<T> of(final Function<String, Optional<T>> parseFunction, final Function<String, CommandInterruptException> generateExceptionFunction) {
        return new ArgumentParser<T>(){

            @Override
            public Optional<T> parse(@Nonnull String t) {
                return (Optional)parseFunction.apply(t);
            }

            @Override
            public CommandInterruptException generateException(@Nonnull String s) {
                return (CommandInterruptException)generateExceptionFunction.apply(s);
            }
        };
    }

    public Optional<T> parse(@Nonnull String var1);

    default public CommandInterruptException generateException(@Nonnull String s) {
        return new CommandInterruptException("&cUnable to parse argument: " + s);
    }

    default public CommandInterruptException generateException(int missingArgumentIndex) {
        return new CommandInterruptException("&cArgument at index " + missingArgumentIndex + " is missing.");
    }

    @Nonnull
    default public T parseOrFail(@Nonnull String s) throws CommandInterruptException {
        Optional<T> ret = this.parse(s);
        if (!ret.isPresent()) {
            throw this.generateException(s);
        }
        return ret.get();
    }

    @Nonnull
    default public Optional<T> parse(@Nonnull Argument argument) {
        return argument.value().flatMap(this::parse);
    }

    @Nonnull
    default public T parseOrFail(@Nonnull Argument argument) throws CommandInterruptException {
        Optional<String> value = argument.value();
        if (!value.isPresent()) {
            throw this.generateException(argument.index());
        }
        return this.parseOrFail(value.get());
    }

    @Nonnull
    default public ArgumentParser<T> thenTry(@Nonnull ArgumentParser<T> other) {
        ArgumentParser first = this;
        return t -> {
            Optional ret = first.parse(t);
            return ret.isPresent() ? ret : other.parse(t);
        };
    }
}

