/*
 * Decompiled with CFR 0.152.
 */
package tsp.nexuslib.player;

import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import tsp.nexuslib.server.ServerVersion;
import tsp.nexuslib.util.StringUtils;

public final class PlayerUtils {
    private PlayerUtils() {
    }

    public static void sendMessage(CommandSender receiver, String message, @Nullable UnaryOperator<String> function, String ... args) {
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                message = message.replace("{$arg" + i + "}", args[i]);
            }
        }
        receiver.sendMessage(StringUtils.colorize(function != null ? (String)function.apply(message) : message));
    }

    public static void sendMessage(CommandSender receiver, String message, @Nullable UnaryOperator<String> function) {
        PlayerUtils.sendMessage(receiver, message, function, (String[])null);
    }

    public static void sendMessage(CommandSender receiver, String message, String ... args) {
        PlayerUtils.sendMessage(receiver, message, null, args);
    }

    public static void sendMessage(CommandSender receiver, String message) {
        PlayerUtils.sendMessage(receiver, message, null, (String[])null);
    }

    public static void sendMessages(String message, CommandSender ... receivers) {
        for (CommandSender receiver : receivers) {
            PlayerUtils.sendMessage(receiver, message);
        }
    }

    public static int getPing(Player player) {
        Optional<ServerVersion> version = ServerVersion.getVersion();
        if (version.isPresent() && version.get().isNewerThanOrEquals(ServerVersion.v_1_17)) {
            return player.getPing();
        }
        try {
            Object entityPlayer = player.getClass().getMethod("getHandle", new Class[0]).invoke((Object)player, new Object[0]);
            return (Integer)entityPlayer.getClass().getField("ping").get(entityPlayer);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            return -1;
        }
    }
}

