/*
 * Decompiled with CFR 0.152.
 */
package tsp.helperlite;

import java.time.Duration;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import tsp.helperlite.command.argument.ArgumentParserRegistry;
import tsp.helperlite.command.argument.SimpleParserRegistry;
import tsp.helperlite.command.functional.FunctionalCommandBuilder;
import tsp.helperlite.util.DurationParser;
import tsp.helperlite.util.Numbers;
import tsp.helperlite.util.Players;

@ParametersAreNonnullByDefault
public final class Commands {
    private static final ArgumentParserRegistry PARSER_REGISTRY = new SimpleParserRegistry();

    @Nonnull
    public static ArgumentParserRegistry parserRegistry() {
        return PARSER_REGISTRY;
    }

    public static FunctionalCommandBuilder<CommandSender> create() {
        return FunctionalCommandBuilder.newBuilder();
    }

    private Commands() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }

    private static Optional<World> world(String name) {
        return Optional.ofNullable(Bukkit.getWorld((String)name));
    }

    static {
        PARSER_REGISTRY.register(String.class, Optional::of);
        PARSER_REGISTRY.register(Number.class, Numbers::parse);
        PARSER_REGISTRY.register(Integer.class, Numbers::parseIntegerOpt);
        PARSER_REGISTRY.register(Long.class, Numbers::parseLongOpt);
        PARSER_REGISTRY.register(Float.class, Numbers::parseFloatOpt);
        PARSER_REGISTRY.register(Double.class, Numbers::parseDoubleOpt);
        PARSER_REGISTRY.register(Byte.class, Numbers::parseByteOpt);
        PARSER_REGISTRY.register(Boolean.class, s -> s.equalsIgnoreCase("true") ? Optional.of(true) : (s.equalsIgnoreCase("false") ? Optional.of(false) : Optional.empty()));
        PARSER_REGISTRY.register(UUID.class, s -> {
            try {
                return Optional.of(UUID.fromString(s));
            }
            catch (IllegalArgumentException e) {
                return Optional.empty();
            }
        });
        PARSER_REGISTRY.register(Player.class, s -> {
            try {
                return Players.get(UUID.fromString(s));
            }
            catch (IllegalArgumentException e) {
                return Players.get(s);
            }
        });
        PARSER_REGISTRY.register(OfflinePlayer.class, s -> {
            try {
                return Players.getOffline(UUID.fromString(s));
            }
            catch (IllegalArgumentException e) {
                return Players.getOffline(s);
            }
        });
        PARSER_REGISTRY.register(World.class, Commands::world);
        PARSER_REGISTRY.register(Duration.class, DurationParser::parseSafely);
    }
}

