/*
 * Decompiled with CFR 0.152.
 */
package tsp.headdb.core.economy;

import java.math.BigDecimal;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;
import tsp.headdb.HeadDB;
import tsp.headdb.core.economy.BasicEconomyProvider;
import tsp.helperlite.scheduler.promise.Promise;

public class VaultProvider
implements BasicEconomyProvider {
    private Economy economy;

    @Override
    public Promise<Boolean> canPurchase(Player player, BigDecimal cost) {
        double effectiveCost = cost.doubleValue();
        return Promise.supplyingAsync(() -> this.economy.has((OfflinePlayer)player, effectiveCost >= 0.0 ? effectiveCost : 0.0));
    }

    @Override
    public Promise<Boolean> withdraw(Player player, BigDecimal amount) {
        double effectiveCost = amount.doubleValue();
        return Promise.supplyingAsync(() -> this.economy.withdrawPlayer((OfflinePlayer)player, effectiveCost >= 0.0 ? effectiveCost : 0.0).transactionSuccess());
    }

    @Override
    public void init() {
        if (Bukkit.getServer().getPluginManager().getPlugin("Vault") == null) {
            HeadDB.getInstance().getLog().error("Vault is not installed!");
            return;
        }
        RegisteredServiceProvider economyProvider = Bukkit.getServer().getServicesManager().getRegistration(Economy.class);
        if (economyProvider == null) {
            HeadDB.getInstance().getLog().error("Could not find vault economy provider!");
            return;
        }
        this.economy = (Economy)economyProvider.getProvider();
    }
}

