/*
 * Decompiled with CFR 0.152.
 */
package tsp.headdb;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import tsp.headdb.Metrics;
import tsp.headdb.core.command.CommandCategory;
import tsp.headdb.core.command.CommandGive;
import tsp.headdb.core.command.CommandHelp;
import tsp.headdb.core.command.CommandInfo;
import tsp.headdb.core.command.CommandLanguage;
import tsp.headdb.core.command.CommandMain;
import tsp.headdb.core.command.CommandManager;
import tsp.headdb.core.command.CommandReload;
import tsp.headdb.core.command.CommandSearch;
import tsp.headdb.core.command.CommandSettings;
import tsp.headdb.core.command.CommandTexture;
import tsp.headdb.core.command.CommandUpdate;
import tsp.headdb.core.economy.BasicEconomyProvider;
import tsp.headdb.core.economy.VaultProvider;
import tsp.headdb.core.storage.Storage;
import tsp.headdb.core.task.UpdateTask;
import tsp.headdb.core.util.HeadDBLogger;
import tsp.headdb.core.util.Utils;
import tsp.helperlite.HelperLite;
import tsp.helperlite.Schedulers;
import tsp.helperlite.scheduler.promise.Promise;
import tsp.helperlite.scheduler.task.Task;
import tsp.nexuslib.NexusPlugin;
import tsp.nexuslib.inventory.PaneListener;
import tsp.nexuslib.localization.TranslatableLocalization;

public class HeadDB
extends NexusPlugin {
    private static HeadDB instance;
    private HeadDBLogger logger;
    private TranslatableLocalization localization;
    private Storage storage;
    private BasicEconomyProvider economyProvider;
    private CommandManager commandManager;
    private Task updateTask;
    private DecimalFormat decimalFormat = new DecimalFormat(this.getConfig().getString("economy.format"));

    @Override
    public void onStart(NexusPlugin nexusPlugin) {
        instance = this;
        HelperLite.init(this);
        instance.saveDefaultConfig();
        HeadDB.instance.logger = new HeadDBLogger(this.getConfig().getBoolean("debug"));
        HeadDB.instance.logger.info("Loading HeadDB - " + Utils.getVersion().orElse(this.getDescription().getVersion() + " (UNKNOWN SEMVER)"));
        HeadDB.instance.logger.info("Loaded " + this.loadLocalization() + " languages!");
        instance.initStorage();
        instance.initEconomy();
        this.startUpdateTask();
        new PaneListener(this);
        HeadDB.instance.commandManager = new CommandManager();
        this.loadCommands();
        this.initMetrics();
        this.ensureLatestVersion();
        HeadDB.instance.logger.info("Done!");
    }

    public void onDisable() {
        if (this.storage != null) {
            this.storage.getPlayerStorage().suspend();
            File langFile = new File(this.getDataFolder(), "langs.data");
            if (!langFile.exists()) {
                try {
                    langFile.createNewFile();
                    this.localization.saveLanguages(langFile);
                }
                catch (IOException ex) {
                    this.logger.error("Failed to save receiver langauges!");
                    ex.printStackTrace();
                }
            }
        }
        this.updateTask.stop();
    }

    private void startUpdateTask() {
        this.updateTask = Schedulers.builder().async().every(this.getConfig().getLong("refresh", 86400L), TimeUnit.SECONDS).run(new UpdateTask());
    }

    private void ensureLatestVersion() {
        Promise.start().thenApplyAsync(a -> {
            try {
                URLConnection connection = new URL("https://api.spigotmc.org/legacy/update.php?resource=84967").openConnection();
                connection.setConnectTimeout(5000);
                connection.setRequestProperty("User-Agent", this.getName() + "-VersionChecker");
                return new BufferedReader(new InputStreamReader(connection.getInputStream())).readLine().equals(Utils.getVersion().orElse(this.getDescription().getVersion()));
            }
            catch (IOException ex) {
                return false;
            }
        }).thenAcceptAsync(latest -> {
            if (latest.booleanValue()) {
                HeadDB.instance.logger.warning("There is a new update available for HeadDB on spigot!");
                HeadDB.instance.logger.warning("Download: https://www.spigotmc.org/resources/84967");
            }
        });
    }

    private void initMetrics() {
        Metrics metrics = new Metrics(this, 9152);
        metrics.addCustomChart(new Metrics.SimplePie("economy_provider", () -> {
            if (this.getEconomyProvider().isPresent()) {
                return this.getConfig().getString("economy.provider");
            }
            return "None";
        }));
    }

    private void initStorage() {
        this.storage = new Storage();
        this.storage.getPlayerStorage().init();
    }

    private int loadLocalization() {
        HeadDB.instance.localization = new TranslatableLocalization(this, "messages");
        try {
            HeadDB.instance.localization.createDefaults();
            int count = HeadDB.instance.localization.load();
            File langFile = new File(this.getDataFolder(), "langs.data");
            if (langFile.exists()) {
                this.localization.loadLanguages(langFile);
            }
            return count;
        }
        catch (IOException | URISyntaxException ex) {
            HeadDB.instance.logger.error("Failed to load localization!");
            ex.printStackTrace();
            this.setEnabled(false);
            return 0;
        }
    }

    private void initEconomy() {
        if (!this.getConfig().getBoolean("economy.enabled")) {
            HeadDB.instance.logger.debug("Economy disabled by config.yml!");
            HeadDB.instance.economyProvider = null;
            return;
        }
        String raw = this.getConfig().getString("economy.provider", "VAULT");
        if (raw.equalsIgnoreCase("VAULT")) {
            this.economyProvider = new VaultProvider();
        }
        this.economyProvider.init();
        HeadDB.instance.logger.info("Economy Provider: " + raw);
    }

    private void loadCommands() {
        PluginCommand main = this.getCommand("headdb");
        if (main == null) {
            HeadDB.instance.logger.error("Could not find main 'headdb' command!");
            this.setEnabled(false);
            return;
        }
        main.setExecutor((CommandExecutor)new CommandMain());
        main.setTabCompleter((TabCompleter)new CommandMain());
        new CommandHelp().register();
        new CommandCategory().register();
        new CommandSearch().register();
        new CommandGive().register();
        new CommandUpdate().register();
        new CommandReload().register();
        new CommandTexture().register();
        new CommandLanguage().register();
        new CommandSettings().register();
        new CommandInfo().register();
    }

    public Optional<Task> getUpdateTask() {
        return Optional.ofNullable(this.updateTask);
    }

    public Storage getStorage() {
        return this.storage;
    }

    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    public Optional<BasicEconomyProvider> getEconomyProvider() {
        return Optional.ofNullable(this.economyProvider);
    }

    public DecimalFormat getDecimalFormat() {
        return this.decimalFormat != null ? this.decimalFormat : (this.decimalFormat = new DecimalFormat("##.##"));
    }

    public TranslatableLocalization getLocalization() {
        return this.localization;
    }

    public HeadDBLogger getLog() {
        return this.logger;
    }

    public static HeadDB getInstance() {
        return instance;
    }
}

