/*
 * Decompiled with CFR 0.152.
 */
package tsp.helperlite.util.terminable;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import tsp.helperlite.util.terminable.TerminableConsumer;

@FunctionalInterface
public interface Terminable
extends AutoCloseable {
    public static final Terminable EMPTY = () -> {};

    @Override
    public void close() throws Exception;

    default public boolean isClosed() {
        return false;
    }

    @Nullable
    default public Exception closeSilently() {
        try {
            this.close();
            return null;
        }
        catch (Exception e) {
            return e;
        }
    }

    default public void closeAndReportException() {
        try {
            this.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    default public void bindWith(@Nonnull TerminableConsumer consumer) {
        consumer.bind(this);
    }
}

