/*
 * Decompiled with CFR 0.152.
 */
package tsp.helperlite.command;

import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;
import tsp.helperlite.HelperLite;
import tsp.helperlite.command.Command;
import tsp.helperlite.command.CommandInterruptException;
import tsp.helperlite.command.CommandMapUtil;
import tsp.helperlite.command.context.ImmutableCommandContext;

@ParametersAreNonnullByDefault
public abstract class AbstractCommand
implements Command,
CommandExecutor,
TabCompleter {
    @Nullable
    protected String permission;
    @Nullable
    protected String permissionMessage;
    @Nullable
    protected String description;

    @Override
    public void register(String ... aliases) {
        CommandMapUtil.registerCommand((Plugin)HelperLite.getPlugin(), this, this.permission, this.permissionMessage, this.description, aliases);
    }

    @Override
    public void close() {
        CommandMapUtil.unregisterCommand(this);
    }

    public boolean onCommand(CommandSender sender, org.bukkit.command.Command command, String label, String[] args) {
        ImmutableCommandContext<CommandSender> context = new ImmutableCommandContext<CommandSender>(sender, label, args, command.getAliases());
        try {
            this.call(context);
        }
        catch (CommandInterruptException e) {
            e.getAction().accept((CommandSender)context.sender());
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, org.bukkit.command.Command command, String label, String[] args) {
        ImmutableCommandContext<CommandSender> context = new ImmutableCommandContext<CommandSender>(sender, label, args, command.getAliases());
        try {
            return this.callTabCompleter(context);
        }
        catch (CommandInterruptException e) {
            e.getAction().accept((CommandSender)context.sender());
            return null;
        }
    }
}

