/*
 * Decompiled with CFR 0.152.
 */
package tsp.warehouse.storage.file;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import tsp.warehouse.storage.file.FileDataManager;

public class JsonFileDataManager<T>
extends FileDataManager<T> {
    private final Type type = new TypeToken<T>(){}.getType();
    private Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();

    public JsonFileDataManager(@Nonnull File file, @Nullable Executor executor) {
        super(file, executor);
    }

    public JsonFileDataManager(@Nonnull File file) {
        this(file, null);
    }

    @Override
    public CompletableFuture<Optional<T>> load() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return Optional.of(this.gson.fromJson((Reader)new FileReader(this.getFile()), this.type));
            }
            catch (FileNotFoundException ex) {
                throw new CompletionException(ex);
            }
        }, this.getExecutor());
    }

    @Override
    public CompletableFuture<Boolean> save(T t) {
        return CompletableFuture.supplyAsync(() -> {
            try (FileWriter writer = new FileWriter(this.getFile());){
                this.gson.toJson(t, this.type, (Appendable)writer);
                Boolean bl = true;
                return bl;
            }
            catch (IOException ex) {
                throw new CompletionException(ex);
            }
        }, this.getExecutor());
    }

    public JsonFileDataManager<T> gson(Gson gson) {
        this.gson = gson;
        return this;
    }

    public Gson getGson() {
        return this.gson;
    }
}

