/*
 * Decompiled with CFR 0.152.
 */
package tsp.headdb.core.command;

import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import tsp.headdb.core.command.SubCommand;
import tsp.headdb.core.util.Utils;
import tsp.nexuslib.builder.ItemBuilder;
import tsp.nexuslib.inventory.Button;
import tsp.nexuslib.inventory.PagedPane;
import tsp.nexuslib.inventory.Pane;
import tsp.nexuslib.util.StringUtils;

public class CommandSettings
extends SubCommand {
    public CommandSettings() {
        super("settings", new String[]{"st"});
    }

    @Override
    public void handle(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            this.getLocalization().sendConsoleMessage("noConsole");
            return;
        }
        Player player = (Player)sender;
        Set<String> languages = this.getLocalization().getData().keySet();
        Pane pane = new Pane(1, StringUtils.colorize(this.getLocalization().getMessage(player.getUniqueId(), "menu.settings.name").orElse("&cHeadDB - Settings")));
        pane.addButton(new Button(new ItemBuilder(Material.BOOK).name(this.getLocalization().getMessage(player.getUniqueId(), "menu.settings.language.name").orElse("&cLanguage")).setLore(this.getLocalization().getMessage(player.getUniqueId(), "menu.settings.language.available").orElse("&7Languages Available: &e%size%").replace("%size%", String.valueOf(languages.size()))).build(), e -> {
            e.setCancelled(true);
            PagedPane langPane = new PagedPane(4, 6, Utils.translateTitle(this.getLocalization().getMessage(player.getUniqueId(), "menu.settings.language.title").orElse("&cHeadDB &7- &eSelect Language").replace("%languages%", "%size%"), languages.size(), "Selector: Language"));
            for (String lang : languages) {
                langPane.addButton(new Button(new ItemBuilder(Material.PAPER).name(this.getLocalization().getMessage(player.getUniqueId(), "menu.settings.language.format").orElse(ChatColor.YELLOW + lang).replace("%language%", lang)).build(), langEvent -> {
                    e.setCancelled(true);
                    this.getLocalization().setLanguage(player.getUniqueId(), lang);
                    this.getLocalization().sendMessage(player.getUniqueId(), "languageChanged", msg -> msg.replace("%language%", lang));
                }));
            }
            langPane.open(player);
        }));
        pane.open(player);
    }
}

