/*
 * Decompiled with CFR 0.152.
 */
package tsp.nexuslib.util;

import java.util.Map;
import javax.annotation.Nonnull;
import org.bukkit.attribute.Attributable;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;

public final class AttributeUtils {
    public static final Attribute[] ATTRIBUTES = Attribute.values();

    private AttributeUtils() {
    }

    public static boolean hasModifier(@Nonnull Attributable attributable, Attribute attribute, AttributeModifier modifier) {
        AttributeInstance instance = attributable.getAttribute(attribute);
        if (instance == null) {
            return false;
        }
        return instance.getModifiers().contains(modifier);
    }

    public static boolean addModifier(@Nonnull Attributable attributable, Attribute attribute, AttributeModifier modifier) {
        AttributeInstance instance = attributable.getAttribute(attribute);
        if (instance == null) {
            return false;
        }
        instance.addModifier(modifier);
        return true;
    }

    public static boolean removeModifier(@Nonnull Attributable attributable, Attribute attribute, AttributeModifier modifier) {
        AttributeInstance instance = attributable.getAttribute(attribute);
        if (instance == null) {
            return false;
        }
        instance.removeModifier(modifier);
        return true;
    }

    public static boolean setAttribute(@Nonnull Attributable attributable, Attribute attribute, double value) {
        AttributeInstance instance = attributable.getAttribute(attribute);
        if (instance == null) {
            return false;
        }
        instance.setBaseValue(value);
        return true;
    }

    public static boolean setAttributes(@Nonnull Attributable attributable, Map<Attribute, Double> attributes) {
        boolean result = true;
        for (Map.Entry<Attribute, Double> entry : attributes.entrySet()) {
            boolean entryResult = AttributeUtils.setAttribute(attributable, entry.getKey(), entry.getValue());
            if (!result || entryResult) continue;
            result = false;
        }
        return result;
    }

    public static boolean isApplicable(@Nonnull Attributable attributable, Attribute attribute) {
        return attributable.getAttribute(attribute) != null;
    }
}

