/*
 * Decompiled with CFR 0.152.
 */
package tsp.nexuslib.persistence;

import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.NamespacedKey;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.persistence.PersistentDataType;
import tsp.nexuslib.persistence.PersistentUUIDDataType;

@ParametersAreNonnullByDefault
public final class PersistentDataAPI {
    private PersistentDataAPI() {
    }

    public static void setByte(PersistentDataHolder holder, NamespacedKey key, byte value) {
        holder.getPersistentDataContainer().set(key, PersistentDataType.BYTE, (Object)value);
    }

    public static void setShort(PersistentDataHolder holder, NamespacedKey key, short value) {
        holder.getPersistentDataContainer().set(key, PersistentDataType.SHORT, (Object)value);
    }

    public static void setInt(PersistentDataHolder holder, NamespacedKey key, int value) {
        holder.getPersistentDataContainer().set(key, PersistentDataType.INTEGER, (Object)value);
    }

    public static void setLong(PersistentDataHolder holder, NamespacedKey key, long value) {
        holder.getPersistentDataContainer().set(key, PersistentDataType.LONG, (Object)value);
    }

    public static void setFloat(PersistentDataHolder holder, NamespacedKey key, float value) {
        holder.getPersistentDataContainer().set(key, PersistentDataType.FLOAT, (Object)Float.valueOf(value));
    }

    public static void setDouble(PersistentDataHolder holder, NamespacedKey key, double value) {
        holder.getPersistentDataContainer().set(key, PersistentDataType.DOUBLE, (Object)value);
    }

    public static void setString(PersistentDataHolder holder, NamespacedKey key, String value) {
        holder.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)value);
    }

    public static void setByteArray(PersistentDataHolder holder, NamespacedKey key, byte ... value) {
        holder.getPersistentDataContainer().set(key, PersistentDataType.BYTE_ARRAY, (Object)value);
    }

    public static void setIntArray(PersistentDataHolder holder, NamespacedKey key, int ... value) {
        holder.getPersistentDataContainer().set(key, PersistentDataType.INTEGER_ARRAY, (Object)value);
    }

    public static void setLongArray(PersistentDataHolder holder, NamespacedKey key, long ... value) {
        holder.getPersistentDataContainer().set(key, PersistentDataType.LONG_ARRAY, (Object)value);
    }

    public static void setContainer(PersistentDataHolder holder, NamespacedKey key, PersistentDataContainer value) {
        holder.getPersistentDataContainer().set(key, PersistentDataType.TAG_CONTAINER, (Object)value);
    }

    public static void setBoolean(PersistentDataHolder holder, NamespacedKey key, boolean value) {
        PersistentDataAPI.setByte(holder, key, value ? (byte)1 : 0);
    }

    public static <T, Z> void set(PersistentDataHolder holder, NamespacedKey key, PersistentDataType<T, Z> type, Z value) {
        holder.getPersistentDataContainer().set(key, type, value);
    }

    public static <T, Z> void setIfAbsent(PersistentDataHolder holder, NamespacedKey key, PersistentDataType<T, Z> type, Z value) {
        if (!PersistentDataAPI.has(holder, key, type)) {
            PersistentDataAPI.set(holder, key, type, value);
        }
    }

    @Deprecated
    public static void setUUID(PersistentDataHolder holder, NamespacedKey key, UUID uuid) {
        holder.getPersistentDataContainer().set(key, PersistentUUIDDataType.TYPE, (Object)uuid);
    }

    public static boolean hasByte(PersistentDataHolder holder, NamespacedKey key) {
        return holder.getPersistentDataContainer().has(key, PersistentDataType.BYTE);
    }

    public static boolean hasShort(PersistentDataHolder holder, NamespacedKey key) {
        return holder.getPersistentDataContainer().has(key, PersistentDataType.SHORT);
    }

    public static boolean hasInt(PersistentDataHolder holder, NamespacedKey key) {
        return holder.getPersistentDataContainer().has(key, PersistentDataType.INTEGER);
    }

    public static boolean hasLong(PersistentDataHolder holder, NamespacedKey key) {
        return holder.getPersistentDataContainer().has(key, PersistentDataType.LONG);
    }

    public static boolean hasFloat(PersistentDataHolder holder, NamespacedKey key) {
        return holder.getPersistentDataContainer().has(key, PersistentDataType.FLOAT);
    }

    public static boolean hasDouble(PersistentDataHolder holder, NamespacedKey key) {
        return holder.getPersistentDataContainer().has(key, PersistentDataType.DOUBLE);
    }

    public static boolean hasString(PersistentDataHolder holder, NamespacedKey key) {
        return holder.getPersistentDataContainer().has(key, PersistentDataType.STRING);
    }

    public static boolean hasByteArray(PersistentDataHolder holder, NamespacedKey key) {
        return holder.getPersistentDataContainer().has(key, PersistentDataType.BYTE_ARRAY);
    }

    public static boolean hasIntArray(PersistentDataHolder holder, NamespacedKey key) {
        return holder.getPersistentDataContainer().has(key, PersistentDataType.INTEGER_ARRAY);
    }

    public static boolean hasLongArray(PersistentDataHolder holder, NamespacedKey key) {
        return holder.getPersistentDataContainer().has(key, PersistentDataType.LONG_ARRAY);
    }

    public static boolean hasContainer(PersistentDataHolder holder, NamespacedKey key) {
        return holder.getPersistentDataContainer().has(key, PersistentDataType.TAG_CONTAINER);
    }

    public static boolean hasBoolean(PersistentDataHolder holder, NamespacedKey key) {
        if (holder.getPersistentDataContainer().has(key, PersistentDataType.BYTE)) {
            byte value = PersistentDataAPI.getByte(holder, key);
            return value == 0 || value == 1;
        }
        return false;
    }

    public static <T, Z> boolean has(PersistentDataHolder holder, NamespacedKey key, PersistentDataType<T, Z> type) {
        return holder.getPersistentDataContainer().has(key, type);
    }

    public static boolean hasUUID(PersistentDataHolder holder, NamespacedKey key) {
        return holder.getPersistentDataContainer().has(key, PersistentUUIDDataType.TYPE);
    }

    public static byte getByte(PersistentDataHolder holder, NamespacedKey key) {
        return (Byte)holder.getPersistentDataContainer().getOrDefault(key, PersistentDataType.BYTE, (Object)-1);
    }

    public static Optional<Byte> getOptionalByte(PersistentDataHolder holder, NamespacedKey key) {
        return !PersistentDataAPI.hasByte(holder, key) ? Optional.empty() : Optional.of(PersistentDataAPI.getByte(holder, key));
    }

    public static byte getByte(PersistentDataHolder holder, NamespacedKey key, byte defaultVal) {
        return (Byte)holder.getPersistentDataContainer().getOrDefault(key, PersistentDataType.BYTE, (Object)defaultVal);
    }

    public static Optional<Boolean> getOptionalBoolean(PersistentDataHolder holder, NamespacedKey key) {
        return !PersistentDataAPI.hasBoolean(holder, key) ? Optional.empty() : Optional.of(PersistentDataAPI.getBoolean(holder, key));
    }

    public static boolean getBoolean(PersistentDataHolder holder, NamespacedKey key) {
        return PersistentDataAPI.getOptionalBoolean(holder, key).orElse(false);
    }

    public static short getShort(PersistentDataHolder holder, NamespacedKey key) {
        return (Short)holder.getPersistentDataContainer().getOrDefault(key, PersistentDataType.SHORT, (Object)-1);
    }

    public static Optional<Short> getOptionalShort(PersistentDataHolder holder, NamespacedKey key) {
        return !PersistentDataAPI.hasShort(holder, key) ? Optional.empty() : Optional.of(PersistentDataAPI.getShort(holder, key));
    }

    public static short getShort(PersistentDataHolder holder, NamespacedKey key, short defaultVal) {
        return (Short)holder.getPersistentDataContainer().getOrDefault(key, PersistentDataType.SHORT, (Object)defaultVal);
    }

    public static int getInt(PersistentDataHolder holder, NamespacedKey key) {
        return (Integer)holder.getPersistentDataContainer().getOrDefault(key, PersistentDataType.INTEGER, (Object)-1);
    }

    public static OptionalInt getOptionalInt(PersistentDataHolder holder, NamespacedKey key) {
        return !PersistentDataAPI.hasInt(holder, key) ? OptionalInt.empty() : OptionalInt.of(PersistentDataAPI.getInt(holder, key));
    }

    public static int getInt(PersistentDataHolder holder, NamespacedKey key, int defaultVal) {
        return (Integer)holder.getPersistentDataContainer().getOrDefault(key, PersistentDataType.INTEGER, (Object)defaultVal);
    }

    public static long getLong(PersistentDataHolder holder, NamespacedKey key) {
        return (Long)holder.getPersistentDataContainer().getOrDefault(key, PersistentDataType.LONG, (Object)-1L);
    }

    public static OptionalLong getOptionalLong(PersistentDataHolder holder, NamespacedKey key) {
        return !PersistentDataAPI.hasLong(holder, key) ? OptionalLong.empty() : OptionalLong.of(PersistentDataAPI.getLong(holder, key));
    }

    public static long getLong(PersistentDataHolder holder, NamespacedKey key, long defaultVal) {
        return (Long)holder.getPersistentDataContainer().getOrDefault(key, PersistentDataType.LONG, (Object)defaultVal);
    }

    public static float getFloat(PersistentDataHolder holder, NamespacedKey key) {
        return ((Float)holder.getPersistentDataContainer().getOrDefault(key, PersistentDataType.FLOAT, (Object)Float.valueOf(-1.0f))).floatValue();
    }

    public static Optional<Float> getOptionalFloat(PersistentDataHolder holder, NamespacedKey key) {
        return !PersistentDataAPI.hasFloat(holder, key) ? Optional.empty() : Optional.of(Float.valueOf(PersistentDataAPI.getFloat(holder, key)));
    }

    public static float getFloat(PersistentDataHolder holder, NamespacedKey key, float defaultVal) {
        return ((Float)holder.getPersistentDataContainer().getOrDefault(key, PersistentDataType.FLOAT, (Object)Float.valueOf(defaultVal))).floatValue();
    }

    public static double getDouble(PersistentDataHolder holder, NamespacedKey key) {
        return (Double)holder.getPersistentDataContainer().getOrDefault(key, PersistentDataType.DOUBLE, (Object)-1.0);
    }

    public static OptionalDouble getOptionalDouble(PersistentDataHolder holder, NamespacedKey key) {
        return !PersistentDataAPI.hasDouble(holder, key) ? OptionalDouble.empty() : OptionalDouble.of(PersistentDataAPI.getDouble(holder, key));
    }

    public static double getDouble(PersistentDataHolder holder, NamespacedKey key, double defaultVal) {
        return (Double)holder.getPersistentDataContainer().getOrDefault(key, PersistentDataType.DOUBLE, (Object)defaultVal);
    }

    public static String getString(PersistentDataHolder holder, NamespacedKey key) {
        return (String)holder.getPersistentDataContainer().get(key, PersistentDataType.STRING);
    }

    public static Optional<String> getOptionalString(PersistentDataHolder holder, NamespacedKey key) {
        return Optional.ofNullable(PersistentDataAPI.getString(holder, key));
    }

    public static String getString(PersistentDataHolder holder, NamespacedKey key, String defaultVal) {
        return (String)holder.getPersistentDataContainer().getOrDefault(key, PersistentDataType.STRING, (Object)defaultVal);
    }

    public static byte[] getByteArray(PersistentDataHolder holder, NamespacedKey key) {
        return (byte[])holder.getPersistentDataContainer().get(key, PersistentDataType.BYTE_ARRAY);
    }

    public static Optional<byte[]> getOptionalByteArray(PersistentDataHolder holder, NamespacedKey key) {
        return Optional.ofNullable(PersistentDataAPI.getByteArray(holder, key));
    }

    public static byte[] getByteArray(PersistentDataHolder holder, NamespacedKey key, byte ... defaultVal) {
        return (byte[])holder.getPersistentDataContainer().getOrDefault(key, PersistentDataType.BYTE_ARRAY, (Object)defaultVal);
    }

    public static int[] getIntArray(PersistentDataHolder holder, NamespacedKey key) {
        return (int[])holder.getPersistentDataContainer().get(key, PersistentDataType.INTEGER_ARRAY);
    }

    public static Optional<int[]> getOptionalIntArray(PersistentDataHolder holder, NamespacedKey key) {
        return Optional.ofNullable(PersistentDataAPI.getIntArray(holder, key));
    }

    public static int[] getIntArray(PersistentDataHolder holder, NamespacedKey key, int ... defaultVal) {
        return (int[])holder.getPersistentDataContainer().getOrDefault(key, PersistentDataType.INTEGER_ARRAY, (Object)defaultVal);
    }

    public static long[] getLongArray(PersistentDataHolder holder, NamespacedKey key) {
        return (long[])holder.getPersistentDataContainer().get(key, PersistentDataType.LONG_ARRAY);
    }

    public static Optional<long[]> getOptionalLongArray(PersistentDataHolder holder, NamespacedKey key) {
        return Optional.ofNullable(PersistentDataAPI.getLongArray(holder, key));
    }

    public static long[] getLongArray(PersistentDataHolder holder, NamespacedKey key, long ... defaultVal) {
        return (long[])holder.getPersistentDataContainer().getOrDefault(key, PersistentDataType.LONG_ARRAY, (Object)defaultVal);
    }

    public static <T, Z> Z get(PersistentDataHolder holder, NamespacedKey key, PersistentDataType<T, Z> type) {
        return (Z)holder.getPersistentDataContainer().get(key, type);
    }

    public static <T, Z> Optional<Z> getOptional(PersistentDataHolder holder, NamespacedKey key, PersistentDataType<T, Z> type) {
        return Optional.ofNullable(holder.getPersistentDataContainer().get(key, type));
    }

    public static <T, Z> Z getOrDefault(PersistentDataHolder holder, NamespacedKey key, PersistentDataType<T, Z> type, Z def) {
        return (Z)holder.getPersistentDataContainer().getOrDefault(key, type, def);
    }

    public static PersistentDataContainer getContainer(PersistentDataHolder holder, NamespacedKey key) {
        return (PersistentDataContainer)holder.getPersistentDataContainer().get(key, PersistentDataType.TAG_CONTAINER);
    }

    public static Optional<PersistentDataContainer> getOptionalContainer(PersistentDataHolder holder, NamespacedKey key) {
        return Optional.ofNullable(PersistentDataAPI.getContainer(holder, key));
    }

    public static PersistentDataContainer getContainer(PersistentDataHolder holder, NamespacedKey key, PersistentDataContainer defaultVal) {
        return (PersistentDataContainer)holder.getPersistentDataContainer().getOrDefault(key, PersistentDataType.TAG_CONTAINER, (Object)defaultVal);
    }

    @Deprecated
    @Nullable
    public static UUID getUUID(PersistentDataHolder holder, NamespacedKey key) {
        return (UUID)holder.getPersistentDataContainer().get(key, PersistentUUIDDataType.TYPE);
    }

    @Deprecated
    @Nonnull
    public static Optional<UUID> getOptionalUUID(PersistentDataHolder holder, NamespacedKey key) {
        return Optional.ofNullable(PersistentDataAPI.getUUID(holder, key));
    }

    public static void remove(PersistentDataHolder holder, NamespacedKey key) {
        holder.getPersistentDataContainer().remove(key);
    }
}

