/*
 * Decompiled with CFR 0.152.
 */
package tsp.headdb.implementation.requester;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.plugin.java.JavaPlugin;
import tsp.headdb.HeadDB;
import tsp.headdb.core.util.Utils;
import tsp.headdb.implementation.category.Category;
import tsp.headdb.implementation.head.Head;
import tsp.headdb.implementation.requester.HeadProvider;
import tsp.headdb.implementation.requester.Response;

public class Requester {
    private final JavaPlugin plugin;
    private HeadProvider provider;

    public Requester(JavaPlugin plugin, HeadProvider provider) {
        this.plugin = plugin;
        this.provider = provider;
    }

    public List<Head> fetchAndResolve(Category category) {
        try {
            Response response = this.fetch(category);
            ArrayList<Head> result = new ArrayList<Head>();
            if (response.code() != 200) {
                return result;
            }
            JsonArray main = JsonParser.parseString((String)response.response()).getAsJsonArray();
            for (JsonElement entry : main) {
                List blockedIds;
                JsonObject obj = entry.getAsJsonObject();
                int id = obj.get("id").getAsInt();
                if (this.plugin.getConfig().contains("blockedHeads.ids") && (blockedIds = this.plugin.getConfig().getIntegerList("blockedHeads.ids")).contains(id)) {
                    HeadDB.getInstance().getLog().debug("Skipped blocked head: " + obj.get("name").getAsString() + "(" + id + ")");
                    continue;
                }
                result.add(new Head(id, Utils.validateUniqueId(obj.get("uuid").getAsString()).orElse(UUID.randomUUID()), obj.get("name").getAsString(), obj.get("value").getAsString(), obj.get("tags").getAsString(), response.date(), category));
            }
            return result;
        }
        catch (IOException ex) {
            HeadDB.getInstance().getLog().debug("Failed to load from provider: " + this.provider.name());
            if (HeadDB.getInstance().getConfig().getBoolean("fallback") && this.provider != HeadProvider.HEAD_ARCHIVE) {
                this.provider = HeadProvider.HEAD_ARCHIVE;
                return this.fetchAndResolve(category);
            }
            HeadDB.getInstance().getLog().error("Could not fetch heads from any provider!");
            return new ArrayList<Head>();
        }
    }

    public Response fetch(Category category) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(this.provider.getFormattedUrl(category)).openConnection();
        connection.setConnectTimeout(5000);
        connection.setRequestMethod("GET");
        connection.setRequestProperty("User-Agent", this.plugin.getName() + "/" + Utils.getVersion().orElse(this.plugin.getDescription().getVersion()));
        connection.setRequestProperty("Accept", "application/json");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            String line;
            StringBuilder builder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                builder.append(line);
            }
            connection.disconnect();
            Response response = new Response(builder.toString(), connection.getResponseCode(), connection.getHeaderField("date"));
            return response;
        }
    }

    public HeadProvider getProvider() {
        return this.provider;
    }

    public JavaPlugin getPlugin() {
        return this.plugin;
    }
}

