/*
 * Decompiled with CFR 0.152.
 */
package tsp.nexuslib.task;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;
import tsp.nexuslib.task.Task;
import tsp.nexuslib.util.Validate;

public class SimpleTask {
    private Runnable task;
    private long delay;
    private long repeat;
    private boolean async;

    public SimpleTask(@Nullable Runnable task) {
        this.task = task;
    }

    public SimpleTask() {
        this(null);
    }

    public SimpleTask task(@Nullable Runnable task) {
        this.task = task;
        return this;
    }

    public SimpleTask delay(@Nonnull Duration delay) {
        Validate.notNull(delay, "Delay must not be null!");
        this.delay = delay.toSeconds() * 20L;
        return this;
    }

    public SimpleTask delay(long ticks) {
        this.delay = ticks;
        return this;
    }

    public SimpleTask repeat(@Nonnull Duration repeat) {
        Validate.notNull(repeat, "Repeat must not be null!");
        this.repeat = repeat.toSeconds() * 20L;
        return this;
    }

    public SimpleTask repeat(long ticks) {
        this.repeat = ticks;
        return this;
    }

    public SimpleTask async(boolean async) {
        this.async = async;
        return this;
    }

    @Nonnull
    public Optional<Runnable> getTask() {
        return Optional.ofNullable(this.task);
    }

    public long getDelay() {
        return this.delay;
    }

    public long getRepeat() {
        return this.repeat;
    }

    public boolean isAsync() {
        return this.async;
    }

    @Nonnull
    public BukkitTask schedule(@Nonnull JavaPlugin plugin) {
        Validate.notNull(plugin, "Plugin must not be null!");
        Validate.notNull(this.task, "Task must not be null!");
        BukkitScheduler scheduler = plugin.getServer().getScheduler();
        if (this.isAsync()) {
            if (this.repeat > -1L && this.delay > -1L) {
                return scheduler.runTaskTimerAsynchronously((Plugin)plugin, this.task, this.delay, this.repeat);
            }
            if (this.repeat > -1L) {
                return scheduler.runTaskTimerAsynchronously((Plugin)plugin, this.task, 0L, this.repeat);
            }
            if (this.delay > -1L) {
                return scheduler.runTaskLaterAsynchronously((Plugin)plugin, this.task, this.delay);
            }
            return scheduler.runTaskAsynchronously((Plugin)plugin, this.task);
        }
        if (this.repeat > -1L && this.delay > -1L) {
            return scheduler.runTaskTimer((Plugin)plugin, this.task, this.delay, this.repeat);
        }
        if (this.repeat > -1L) {
            return scheduler.runTaskTimer((Plugin)plugin, this.task, 0L, this.repeat);
        }
        if (this.delay > -1L) {
            return scheduler.runTaskLater((Plugin)plugin, this.task, this.delay);
        }
        return scheduler.runTask((Plugin)plugin, this.task);
    }

    @Nonnull
    public static List<BukkitTask> schedule(@Nonnull JavaPlugin plugin, Task ... tasks) {
        Validate.notNull(plugin, "Plugin must not be null!");
        Validate.notNull(tasks, "Tasks must not be null!");
        ArrayList<BukkitTask> result = new ArrayList<BukkitTask>();
        for (Task task : tasks) {
            result.add(task.schedule(plugin));
        }
        return result;
    }
}

