/*
 * Decompiled with CFR 0.152.
 */
package tsp.helperlite.scheduler;

import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import tsp.helperlite.scheduler.ThreadContext;
import tsp.helperlite.scheduler.promise.Promise;
import tsp.helperlite.scheduler.task.Task;
import tsp.helperlite.util.delegate.Delegates;

public interface Scheduler
extends Executor {
    @Nonnull
    public ThreadContext getContext();

    @Nonnull
    default public <T> Promise<T> supply(@Nonnull Supplier<T> supplier) {
        Objects.requireNonNull(supplier, "supplier");
        return Promise.supplying(this.getContext(), supplier);
    }

    @Nonnull
    default public <T> Promise<T> call(@Nonnull Callable<T> callable) {
        Objects.requireNonNull(callable, "callable");
        return Promise.supplying(this.getContext(), Delegates.callableToSupplier(callable));
    }

    @Nonnull
    default public Promise<Void> run(@Nonnull Runnable runnable) {
        Objects.requireNonNull(runnable, "runnable");
        return Promise.supplying(this.getContext(), Delegates.runnableToSupplier(runnable));
    }

    @Nonnull
    default public <T> Promise<T> supplyLater(@Nonnull Supplier<T> supplier, long delayTicks) {
        Objects.requireNonNull(supplier, "supplier");
        return Promise.supplyingDelayed(this.getContext(), supplier, delayTicks);
    }

    @Nonnull
    default public <T> Promise<T> supplyLater(@Nonnull Supplier<T> supplier, long delay, @Nonnull TimeUnit unit) {
        Objects.requireNonNull(supplier, "supplier");
        return Promise.supplyingDelayed(this.getContext(), supplier, delay, unit);
    }

    @Nonnull
    default public <T> Promise<T> callLater(@Nonnull Callable<T> callable, long delayTicks) {
        Objects.requireNonNull(callable, "callable");
        return Promise.supplyingDelayed(this.getContext(), Delegates.callableToSupplier(callable), delayTicks);
    }

    @Nonnull
    default public <T> Promise<T> callLater(@Nonnull Callable<T> callable, long delay, @Nonnull TimeUnit unit) {
        Objects.requireNonNull(callable, "callable");
        return Promise.supplyingDelayed(this.getContext(), Delegates.callableToSupplier(callable), delay, unit);
    }

    @Nonnull
    default public Promise<Void> runLater(@Nonnull Runnable runnable, long delayTicks) {
        Objects.requireNonNull(runnable, "runnable");
        return Promise.supplyingDelayed(this.getContext(), Delegates.runnableToSupplier(runnable), delayTicks);
    }

    @Nonnull
    default public Promise<Void> runLater(@Nonnull Runnable runnable, long delay, @Nonnull TimeUnit unit) {
        Objects.requireNonNull(runnable, "runnable");
        return Promise.supplyingDelayed(this.getContext(), Delegates.runnableToSupplier(runnable), delay, unit);
    }

    @Nonnull
    public Task runRepeating(@Nonnull Consumer<Task> var1, long var2, long var4);

    @Nonnull
    public Task runRepeating(@Nonnull Consumer<Task> var1, long var2, @Nonnull TimeUnit var4, long var5, @Nonnull TimeUnit var7);

    @Nonnull
    default public Task runRepeating(@Nonnull Runnable runnable, long delayTicks, long intervalTicks) {
        return this.runRepeating(Delegates.runnableToConsumer(runnable), delayTicks, intervalTicks);
    }

    @Nonnull
    default public Task runRepeating(@Nonnull Runnable runnable, long delay, @Nonnull TimeUnit delayUnit, long interval, @Nonnull TimeUnit intervalUnit) {
        return this.runRepeating(Delegates.runnableToConsumer(runnable), delay, delayUnit, interval, intervalUnit);
    }
}

