/*
 * Decompiled with CFR 0.152.
 */
package tsp.helperlite;

import java.util.Objects;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitScheduler;
import tsp.helperlite.HelperLite;
import tsp.helperlite.scheduler.HelperExecutors;
import tsp.helperlite.scheduler.Scheduler;
import tsp.helperlite.scheduler.ThreadContext;
import tsp.helperlite.scheduler.Ticks;
import tsp.helperlite.scheduler.task.Task;
import tsp.helperlite.scheduler.task.builder.TaskBuilder;
import tsp.helperlite.util.HelperExceptions;
import tsp.helperlite.util.delegate.Delegate;

@ParametersAreNonnullByDefault
public final class Schedulers {
    private static final Scheduler SYNC_SCHEDULER = new SyncScheduler();
    private static final Scheduler ASYNC_SCHEDULER = new AsyncScheduler();

    public static Scheduler get(ThreadContext context) {
        return switch (context) {
            default -> throw new IncompatibleClassChangeError();
            case ThreadContext.SYNC -> Schedulers.sync();
            case ThreadContext.ASYNC -> Schedulers.async();
        };
    }

    public static Scheduler sync() {
        return SYNC_SCHEDULER;
    }

    public static Scheduler async() {
        return ASYNC_SCHEDULER;
    }

    public static BukkitScheduler bukkit() {
        return HelperLite.getPlugin().getServer().getScheduler();
    }

    public static TaskBuilder builder() {
        return TaskBuilder.newBuilder();
    }

    private Schedulers() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }

    private static final class SyncScheduler
    implements Scheduler {
        private SyncScheduler() {
        }

        @Override
        public void execute(Runnable runnable) {
            HelperExecutors.sync().execute(runnable);
        }

        @Override
        @Nonnull
        public ThreadContext getContext() {
            return ThreadContext.SYNC;
        }

        @Override
        @Nonnull
        public Task runRepeating(@Nonnull Consumer<Task> consumer, long delayTicks, long intervalTicks) {
            Objects.requireNonNull(consumer, "consumer");
            HelperTask task = new HelperTask(consumer);
            task.runTaskTimer((Plugin)HelperLite.getPlugin(), delayTicks, intervalTicks);
            return task;
        }

        @Override
        @Nonnull
        public Task runRepeating(@Nonnull Consumer<Task> consumer, long delay, @Nonnull TimeUnit delayUnit, long interval, @Nonnull TimeUnit intervalUnit) {
            return this.runRepeating(consumer, Ticks.from(delay, delayUnit), Ticks.from(interval, intervalUnit));
        }
    }

    private static final class AsyncScheduler
    implements Scheduler {
        private AsyncScheduler() {
        }

        @Override
        public void execute(Runnable runnable) {
            HelperExecutors.asyncHelper().execute(runnable);
        }

        @Override
        @Nonnull
        public ThreadContext getContext() {
            return ThreadContext.ASYNC;
        }

        @Override
        @Nonnull
        public Task runRepeating(@Nonnull Consumer<Task> consumer, long delayTicks, long intervalTicks) {
            Objects.requireNonNull(consumer, "consumer");
            HelperTask task = new HelperTask(consumer);
            task.runTaskTimerAsynchronously((Plugin)HelperLite.getPlugin(), delayTicks, intervalTicks);
            return task;
        }

        @Override
        @Nonnull
        public Task runRepeating(@Nonnull Consumer<Task> consumer, long delay, @Nonnull TimeUnit delayUnit, long interval, @Nonnull TimeUnit intervalUnit) {
            Objects.requireNonNull(consumer, "consumer");
            return new HelperAsyncTask(consumer, delay, delayUnit, interval, intervalUnit);
        }
    }

    private static class HelperAsyncTask
    implements Runnable,
    Task,
    Delegate<Consumer<Task>> {
        private final Consumer<Task> backingTask;
        private final ScheduledFuture<?> future;
        private final AtomicInteger counter = new AtomicInteger(0);
        private final AtomicBoolean cancelled = new AtomicBoolean(false);

        private HelperAsyncTask(Consumer<Task> backingTask, long delay, TimeUnit delayUnit, long interval, TimeUnit intervalUnit) {
            this.backingTask = backingTask;
            this.future = HelperExecutors.asyncHelper().scheduleAtFixedRate(this, delayUnit.toNanos(delay), intervalUnit.toNanos(interval), TimeUnit.NANOSECONDS);
        }

        @Override
        public void run() {
            if (this.cancelled.get()) {
                return;
            }
            try {
                this.backingTask.accept(this);
                this.counter.incrementAndGet();
            }
            catch (Throwable e) {
                HelperExceptions.reportScheduler(e);
            }
        }

        @Override
        public int getTimesRan() {
            return this.counter.get();
        }

        @Override
        public boolean stop() {
            if (!this.cancelled.getAndSet(true)) {
                this.future.cancel(false);
                return true;
            }
            return false;
        }

        @Override
        public int getBukkitId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isClosed() {
            return this.cancelled.get();
        }

        @Override
        public Consumer<Task> getDelegate() {
            return this.backingTask;
        }
    }

    private static class HelperTask
    extends BukkitRunnable
    implements Task,
    Delegate<Consumer<Task>> {
        private final Consumer<Task> backingTask;
        private final AtomicInteger counter = new AtomicInteger(0);
        private final AtomicBoolean cancelled = new AtomicBoolean(false);

        private HelperTask(Consumer<Task> backingTask) {
            this.backingTask = backingTask;
        }

        public void run() {
            if (this.cancelled.get()) {
                this.cancel();
                return;
            }
            try {
                this.backingTask.accept(this);
                this.counter.incrementAndGet();
            }
            catch (Throwable e) {
                HelperExceptions.reportScheduler(e);
            }
            if (this.cancelled.get()) {
                this.cancel();
            }
        }

        @Override
        public int getTimesRan() {
            return this.counter.get();
        }

        @Override
        public boolean stop() {
            return !this.cancelled.getAndSet(true);
        }

        @Override
        public int getBukkitId() {
            return this.getTaskId();
        }

        @Override
        public boolean isClosed() {
            return this.cancelled.get();
        }

        @Override
        public Consumer<Task> getDelegate() {
            return this.backingTask;
        }
    }
}

