/*
 * Decompiled with CFR 0.152.
 */
package tsp.nexuslib.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.attribute.Attributable;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;

@ParametersAreNonnullByDefault
public final class EntityUtils {
    private EntityUtils() {
    }

    public static void heal(Damageable target, double amount) {
        if (target instanceof Attributable) {
            Attributable attributable = (Attributable)target;
            target.setHealth(Math.min(attributable.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue(), target.getHealth() + amount));
        }
    }

    public static void kill(Damageable target, @Nullable Entity source) {
        if (source == null) {
            target.setHealth(0.0);
        } else {
            target.damage(target.getHealth(), source);
        }
    }

    public static void kill(Damageable target) {
        EntityUtils.kill(target, null);
    }

    public static Set<Entity> getAllEntities(Predicate<Entity> filter, boolean onlyLiving) {
        Iterator iterator = Bukkit.getWorlds().iterator();
        if (iterator.hasNext()) {
            World world = (World)iterator.next();
            if (onlyLiving) {
                return world.getLivingEntities().stream().filter(filter).collect(Collectors.toSet());
            }
            return world.getEntities().stream().filter(filter).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    public static Set<Entity> getAllEntities(Predicate<Entity> filter) {
        return EntityUtils.getAllEntities(filter, false);
    }

    public static Set<Entity> getNearbyEntities(Entity source, double x, double y, double z, Predicate<Entity> filter) {
        return source.getNearbyEntities(x, y, z).stream().filter(entity -> !entity.getUniqueId().equals(source.getUniqueId())).filter(filter).collect(Collectors.toSet());
    }

    public static Collection<Entity> getNearbyEntities(Entity source, double radius, Predicate<Entity> filter) {
        return EntityUtils.getNearbyEntities(source, radius, radius, radius, filter);
    }
}

