/*
 * Decompiled with CFR 0.152.
 */
package tsp.headdb.core.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import tsp.headdb.HeadDB;
import tsp.headdb.core.storage.PlayerData;
import tsp.headdb.core.util.Utils;
import tsp.headdb.implementation.category.Category;
import tsp.headdb.implementation.head.Head;
import tsp.headdb.implementation.head.HeadDatabase;
import tsp.headdb.implementation.head.LocalHead;
import tsp.headdb.implementation.requester.HeadProvider;
import tsp.helperlite.scheduler.promise.Promise;

public final class HeadAPI {
    private static final HeadDatabase database = new HeadDatabase(HeadDB.getInstance(), HeadProvider.HEAD_STORAGE);

    private HeadAPI() {
    }

    @Nonnull
    public static List<Head> getHeadsByName(String name, boolean lenient) {
        return HeadAPI.getHeads().stream().filter(head -> lenient ? Utils.matches(head.getName(), name) : head.getName().equalsIgnoreCase(name)).collect(Collectors.toList());
    }

    @Nonnull
    public static List<Head> getHeadsByName(String name) {
        return HeadAPI.getHeadsByName(name, true);
    }

    public static Optional<Head> getHeadByExactName(String name, boolean lenient) {
        return HeadAPI.getHeads().stream().filter(head -> lenient ? Utils.matches(head.getName(), name) : head.getName().equalsIgnoreCase(name)).findAny();
    }

    @Nonnull
    public static Optional<Head> getHeadByExactName(String name) {
        return HeadAPI.getHeadByExactName(name, false);
    }

    @Nonnull
    public static Optional<Head> getHeadById(int id) {
        return HeadAPI.getHeads().stream().filter(head -> head.getId() == id).findAny();
    }

    @Nonnull
    public static Optional<Head> getHeadByTexture(String texture) {
        return HeadAPI.getHeads().stream().filter(head -> head.getTexture().equals(texture)).findAny();
    }

    @Nonnull
    public static List<Head> getHeads() {
        ArrayList<Head> result = new ArrayList<Head>();
        for (Category category : HeadAPI.getHeadsMap().keySet()) {
            result.addAll(HeadAPI.getHeads(category));
        }
        return result;
    }

    @Nonnull
    public static List<Head> getHeads(Category category) {
        return HeadAPI.getHeadsMap().get((Object)category);
    }

    @Nonnull
    public static Map<Category, List<Head>> getHeadsMap() {
        return Collections.unmodifiableMap(database.getHeads());
    }

    public static int getTotalHeads() {
        return HeadAPI.getHeads().size();
    }

    @Nonnull
    public static Set<LocalHead> getLocalHeads() {
        return Arrays.stream(Bukkit.getOfflinePlayers()).map(player -> new LocalHead(player.getUniqueId(), player.getName())).collect(Collectors.toSet());
    }

    @Nonnull
    public static Promise<List<Head>> getFavoriteHeads(UUID player) {
        return Promise.supplyingAsync(() -> {
            ArrayList result = new ArrayList();
            Optional<PlayerData> data = HeadDB.getInstance().getStorage().getPlayerStorage().get(player);
            data.ifPresent(playerData -> playerData.favorites().forEach(texture -> HeadAPI.getHeadByTexture(texture).ifPresent(result::add)));
            return result;
        });
    }

    @Nonnull
    public static HeadDatabase getDatabase() {
        return database;
    }
}

