/*
 * Decompiled with CFR 0.152.
 */
package tsp.helperlite.scheduler.promise;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import tsp.helperlite.HelperLite;
import tsp.helperlite.scheduler.HelperExecutors;
import tsp.helperlite.scheduler.ThreadContext;
import tsp.helperlite.scheduler.promise.Promise;
import tsp.helperlite.scheduler.task.Ticks;
import tsp.helperlite.util.HelperExceptions;
import tsp.helperlite.util.delegate.Delegate;

final class HelperPromise<V>
implements Promise<V> {
    private final AtomicBoolean supplied = new AtomicBoolean(false);
    private final AtomicBoolean cancelled = new AtomicBoolean(false);
    @Nonnull
    private final CompletableFuture<V> fut;

    @Nonnull
    static <U> HelperPromise<U> empty() {
        return new HelperPromise();
    }

    @Nonnull
    static <U> HelperPromise<U> completed(@Nullable U value) {
        return new HelperPromise<U>(value);
    }

    @Nonnull
    static <U> HelperPromise<U> exceptionally(@Nonnull Throwable t) {
        return new HelperPromise(t);
    }

    @Nonnull
    static <U> Promise<U> wrapFuture(@Nonnull Future<U> future) {
        if (future instanceof CompletableFuture) {
            return new HelperPromise(((CompletableFuture)future).thenApply(Function.identity()));
        }
        if (future instanceof CompletionStage) {
            CompletionStage fut = (CompletionStage)((Object)future);
            return new HelperPromise(fut.toCompletableFuture().thenApply(Function.identity()));
        }
        if (future instanceof ListenableFuture) {
            ListenableFuture fut = (ListenableFuture)future;
            final HelperPromise<U> promise = HelperPromise.empty();
            promise.supplied.set(true);
            Futures.addCallback((ListenableFuture)fut, (FutureCallback)new FutureCallback<U>(){

                public void onSuccess(@Nullable U result) {
                    promise.complete(result);
                }

                public void onFailure(@Nonnull Throwable t) {
                    promise.completeExceptionally(t);
                }
            }, (Executor)promise.fut.defaultExecutor());
            return promise;
        }
        if (future.isDone()) {
            try {
                return HelperPromise.completed(future.get());
            }
            catch (ExecutionException e) {
                return HelperPromise.exceptionally(e);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return Promise.supplyingExceptionallyAsync(future::get);
    }

    private HelperPromise() {
        this.fut = new CompletableFuture();
    }

    private HelperPromise(@Nullable V v) {
        this.fut = CompletableFuture.completedFuture(v);
        this.supplied.set(true);
    }

    private HelperPromise(@Nonnull Throwable t) {
        this.fut = new CompletableFuture();
        this.fut.completeExceptionally(t);
        this.supplied.set(true);
    }

    private HelperPromise(@Nonnull CompletableFuture<V> fut) {
        this.fut = Objects.requireNonNull(fut, "future");
        this.supplied.set(true);
        this.cancelled.set(fut.isCancelled());
    }

    private void executeSync(@Nonnull Runnable runnable) {
        if (ThreadContext.forCurrentThread() == ThreadContext.SYNC) {
            HelperExceptions.wrapSchedulerTask(runnable).run();
        } else {
            HelperExecutors.sync().execute(runnable);
        }
    }

    private void executeAsync(@Nonnull Runnable runnable) {
        HelperExecutors.asyncHelper().execute(runnable);
    }

    private void executeDelayedSync(@Nonnull Runnable runnable, long delayTicks) {
        if (delayTicks <= 0L) {
            this.executeSync(runnable);
        } else {
            Bukkit.getScheduler().runTaskLater((Plugin)HelperLite.getPlugin(), HelperExceptions.wrapSchedulerTask(runnable), delayTicks);
        }
    }

    private void executeDelayedAsync(@Nonnull Runnable runnable, long delayTicks) {
        if (delayTicks <= 0L) {
            this.executeAsync(runnable);
        } else {
            Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)HelperLite.getPlugin(), HelperExceptions.wrapSchedulerTask(runnable), delayTicks);
        }
    }

    private void executeDelayedSync(@Nonnull Runnable runnable, long delay, TimeUnit unit) {
        if (delay <= 0L) {
            this.executeSync(runnable);
        } else {
            Bukkit.getScheduler().runTaskLater((Plugin)HelperLite.getPlugin(), HelperExceptions.wrapSchedulerTask(runnable), Ticks.from(delay, unit));
        }
    }

    private void executeDelayedAsync(@Nonnull Runnable runnable, long delay, TimeUnit unit) {
        if (delay <= 0L) {
            this.executeAsync(runnable);
        } else {
            HelperExecutors.asyncHelper().schedule(HelperExceptions.wrapSchedulerTask(runnable), delay, unit);
        }
    }

    private boolean complete(V value) {
        return !this.cancelled.get() && this.fut.complete(value);
    }

    private boolean completeExceptionally(@Nonnull Throwable t) {
        return !this.cancelled.get() && this.fut.completeExceptionally(t);
    }

    private void markAsSupplied() {
        if (!this.supplied.compareAndSet(false, true)) {
            throw new IllegalStateException("Promise is already being supplied.");
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.cancelled.set(true);
        return this.fut.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.fut.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.fut.isDone();
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        return this.fut.get();
    }

    @Override
    public V get(long timeout, @Nonnull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.fut.get(timeout, unit);
    }

    @Override
    public V join() {
        return this.fut.join();
    }

    @Override
    public V getNow(V valueIfAbsent) {
        return this.fut.getNow(valueIfAbsent);
    }

    @Override
    public CompletableFuture<V> toCompletableFuture() {
        return this.fut.thenApply(Function.identity());
    }

    @Override
    public void close() {
        this.cancel();
    }

    @Override
    public boolean isClosed() {
        return this.isCancelled();
    }

    @Override
    @Nonnull
    public Promise<V> supply(@Nullable V value) {
        this.markAsSupplied();
        this.complete(value);
        return this;
    }

    @Override
    @Nonnull
    public Promise<V> supplyException(@Nonnull Throwable exception) {
        this.markAsSupplied();
        this.completeExceptionally(exception);
        return this;
    }

    @Override
    @Nonnull
    public Promise<V> supplySync(@Nonnull Supplier<V> supplier) {
        this.markAsSupplied();
        this.executeSync(new SupplyRunnable(supplier));
        return this;
    }

    @Override
    @Nonnull
    public Promise<V> supplyAsync(@Nonnull Supplier<V> supplier) {
        this.markAsSupplied();
        this.executeAsync(new SupplyRunnable(supplier));
        return this;
    }

    @Override
    @Nonnull
    public Promise<V> supplyDelayedSync(@Nonnull Supplier<V> supplier, long delayTicks) {
        this.markAsSupplied();
        this.executeDelayedSync(new SupplyRunnable(supplier), delayTicks);
        return this;
    }

    @Override
    @Nonnull
    public Promise<V> supplyDelayedSync(@Nonnull Supplier<V> supplier, long delay, @Nonnull TimeUnit unit) {
        this.markAsSupplied();
        this.executeDelayedSync(new SupplyRunnable(supplier), delay, unit);
        return this;
    }

    @Override
    @Nonnull
    public Promise<V> supplyDelayedAsync(@Nonnull Supplier<V> supplier, long delayTicks) {
        this.markAsSupplied();
        this.executeDelayedAsync(new SupplyRunnable(supplier), delayTicks);
        return this;
    }

    @Override
    @Nonnull
    public Promise<V> supplyDelayedAsync(@Nonnull Supplier<V> supplier, long delay, @Nonnull TimeUnit unit) {
        this.markAsSupplied();
        this.executeDelayedAsync(new SupplyRunnable(supplier), delay, unit);
        return this;
    }

    @Override
    @Nonnull
    public Promise<V> supplyExceptionallySync(@Nonnull Callable<V> callable) {
        this.markAsSupplied();
        this.executeSync(new ThrowingSupplyRunnable(callable));
        return this;
    }

    @Override
    @Nonnull
    public Promise<V> supplyExceptionallyAsync(@Nonnull Callable<V> callable) {
        this.markAsSupplied();
        this.executeAsync(new ThrowingSupplyRunnable(callable));
        return this;
    }

    @Override
    @Nonnull
    public Promise<V> supplyExceptionallyDelayedSync(@Nonnull Callable<V> callable, long delayTicks) {
        this.markAsSupplied();
        this.executeDelayedSync(new ThrowingSupplyRunnable(callable), delayTicks);
        return this;
    }

    @Override
    @Nonnull
    public Promise<V> supplyExceptionallyDelayedSync(@Nonnull Callable<V> callable, long delay, @Nonnull TimeUnit unit) {
        this.markAsSupplied();
        this.executeDelayedSync(new ThrowingSupplyRunnable(callable), delay, unit);
        return this;
    }

    @Override
    @Nonnull
    public Promise<V> supplyExceptionallyDelayedAsync(@Nonnull Callable<V> callable, long delayTicks) {
        this.markAsSupplied();
        this.executeDelayedAsync(new ThrowingSupplyRunnable(callable), delayTicks);
        return this;
    }

    @Override
    @Nonnull
    public Promise<V> supplyExceptionallyDelayedAsync(@Nonnull Callable<V> callable, long delay, @Nonnull TimeUnit unit) {
        this.markAsSupplied();
        this.executeDelayedAsync(new ThrowingSupplyRunnable(callable), delay, unit);
        return this;
    }

    @Override
    @Nonnull
    public <U> Promise<U> thenApplySync(@Nonnull Function<? super V, ? extends U> fn) {
        HelperPromise promise = HelperPromise.empty();
        this.fut.whenComplete((value, t) -> {
            if (t != null) {
                promise.completeExceptionally((Throwable)t);
            } else {
                this.executeSync(new ApplyRunnable(promise, fn, value));
            }
        });
        return promise;
    }

    @Override
    @Nonnull
    public <U> Promise<U> thenApplyAsync(@Nonnull Function<? super V, ? extends U> fn) {
        HelperPromise promise = HelperPromise.empty();
        this.fut.whenComplete((value, t) -> {
            if (t != null) {
                promise.completeExceptionally((Throwable)t);
            } else {
                this.executeAsync(new ApplyRunnable(promise, fn, value));
            }
        });
        return promise;
    }

    @Override
    @Nonnull
    public <U> Promise<U> thenApplyDelayedSync(@Nonnull Function<? super V, ? extends U> fn, long delayTicks) {
        HelperPromise promise = HelperPromise.empty();
        this.fut.whenComplete((value, t) -> {
            if (t != null) {
                promise.completeExceptionally((Throwable)t);
            } else {
                this.executeDelayedSync(new ApplyRunnable(promise, fn, value), delayTicks);
            }
        });
        return promise;
    }

    @Override
    @Nonnull
    public <U> Promise<U> thenApplyDelayedSync(@Nonnull Function<? super V, ? extends U> fn, long delay, @Nonnull TimeUnit unit) {
        HelperPromise promise = HelperPromise.empty();
        this.fut.whenComplete((value, t) -> {
            if (t != null) {
                promise.completeExceptionally((Throwable)t);
            } else {
                this.executeDelayedSync(new ApplyRunnable(promise, fn, value), delay, unit);
            }
        });
        return promise;
    }

    @Override
    @Nonnull
    public <U> Promise<U> thenApplyDelayedAsync(@Nonnull Function<? super V, ? extends U> fn, long delayTicks) {
        HelperPromise promise = HelperPromise.empty();
        this.fut.whenComplete((value, t) -> {
            if (t != null) {
                promise.completeExceptionally((Throwable)t);
            } else {
                this.executeDelayedAsync(new ApplyRunnable(promise, fn, value), delayTicks);
            }
        });
        return promise;
    }

    @Override
    @Nonnull
    public <U> Promise<U> thenApplyDelayedAsync(@Nonnull Function<? super V, ? extends U> fn, long delay, @Nonnull TimeUnit unit) {
        HelperPromise promise = HelperPromise.empty();
        this.fut.whenComplete((value, t) -> {
            if (t != null) {
                promise.completeExceptionally((Throwable)t);
            } else {
                this.executeDelayedAsync(new ApplyRunnable(promise, fn, value), delay, unit);
            }
        });
        return promise;
    }

    @Override
    @Nonnull
    public <U> Promise<U> thenComposeSync(@Nonnull Function<? super V, ? extends Promise<U>> fn) {
        HelperPromise promise = HelperPromise.empty();
        this.fut.whenComplete((value, t) -> {
            if (t != null) {
                promise.completeExceptionally((Throwable)t);
            } else {
                this.executeSync(new ComposeRunnable(promise, fn, value, true));
            }
        });
        return promise;
    }

    @Override
    @Nonnull
    public <U> Promise<U> thenComposeAsync(@Nonnull Function<? super V, ? extends Promise<U>> fn) {
        HelperPromise promise = HelperPromise.empty();
        this.fut.whenComplete((value, t) -> {
            if (t != null) {
                promise.completeExceptionally((Throwable)t);
            } else {
                this.executeAsync(new ComposeRunnable(promise, fn, value, false));
            }
        });
        return promise;
    }

    @Override
    @Nonnull
    public <U> Promise<U> thenComposeDelayedSync(@Nonnull Function<? super V, ? extends Promise<U>> fn, long delayTicks) {
        HelperPromise promise = HelperPromise.empty();
        this.fut.whenComplete((value, t) -> {
            if (t != null) {
                promise.completeExceptionally((Throwable)t);
            } else {
                this.executeDelayedSync(new ComposeRunnable(promise, fn, value, true), delayTicks);
            }
        });
        return promise;
    }

    @Override
    @Nonnull
    public <U> Promise<U> thenComposeDelayedSync(@Nonnull Function<? super V, ? extends Promise<U>> fn, long delay, @Nonnull TimeUnit unit) {
        HelperPromise promise = HelperPromise.empty();
        this.fut.whenComplete((value, t) -> {
            if (t != null) {
                promise.completeExceptionally((Throwable)t);
            } else {
                this.executeDelayedSync(new ComposeRunnable(promise, fn, value, true), delay, unit);
            }
        });
        return promise;
    }

    @Override
    @Nonnull
    public <U> Promise<U> thenComposeDelayedAsync(@Nonnull Function<? super V, ? extends Promise<U>> fn, long delayTicks) {
        HelperPromise promise = HelperPromise.empty();
        this.fut.whenComplete((value, t) -> {
            if (t != null) {
                promise.completeExceptionally((Throwable)t);
            } else {
                this.executeDelayedAsync(new ComposeRunnable(promise, fn, value, false), delayTicks);
            }
        });
        return promise;
    }

    @Override
    @Nonnull
    public <U> Promise<U> thenComposeDelayedAsync(@Nonnull Function<? super V, ? extends Promise<U>> fn, long delay, @Nonnull TimeUnit unit) {
        HelperPromise promise = HelperPromise.empty();
        this.fut.whenComplete((value, t) -> {
            if (t != null) {
                promise.completeExceptionally((Throwable)t);
            } else {
                this.executeDelayedAsync(new ComposeRunnable(promise, fn, value, false), delay, unit);
            }
        });
        return promise;
    }

    @Override
    @Nonnull
    public Promise<V> exceptionallySync(@Nonnull Function<Throwable, ? extends V> fn) {
        HelperPromise promise = HelperPromise.empty();
        this.fut.whenComplete((value, t) -> {
            if (t == null) {
                promise.complete(value);
            } else {
                this.executeSync(new ExceptionallyRunnable(promise, fn, (Throwable)t));
            }
        });
        return promise;
    }

    @Override
    @Nonnull
    public Promise<V> exceptionallyAsync(@Nonnull Function<Throwable, ? extends V> fn) {
        HelperPromise promise = HelperPromise.empty();
        this.fut.whenComplete((value, t) -> {
            if (t == null) {
                promise.complete(value);
            } else {
                this.executeAsync(new ExceptionallyRunnable(promise, fn, (Throwable)t));
            }
        });
        return promise;
    }

    @Override
    @Nonnull
    public Promise<V> exceptionallyDelayedSync(@Nonnull Function<Throwable, ? extends V> fn, long delayTicks) {
        HelperPromise promise = HelperPromise.empty();
        this.fut.whenComplete((value, t) -> {
            if (t == null) {
                promise.complete(value);
            } else {
                this.executeDelayedSync(new ExceptionallyRunnable(promise, fn, (Throwable)t), delayTicks);
            }
        });
        return promise;
    }

    @Override
    @Nonnull
    public Promise<V> exceptionallyDelayedSync(@Nonnull Function<Throwable, ? extends V> fn, long delay, @Nonnull TimeUnit unit) {
        HelperPromise promise = HelperPromise.empty();
        this.fut.whenComplete((value, t) -> {
            if (t == null) {
                promise.complete(value);
            } else {
                this.executeDelayedSync(new ExceptionallyRunnable(promise, fn, (Throwable)t), delay, unit);
            }
        });
        return promise;
    }

    @Override
    @Nonnull
    public Promise<V> exceptionallyDelayedAsync(@Nonnull Function<Throwable, ? extends V> fn, long delayTicks) {
        HelperPromise promise = HelperPromise.empty();
        this.fut.whenComplete((value, t) -> {
            if (t == null) {
                promise.complete(value);
            } else {
                this.executeDelayedAsync(new ExceptionallyRunnable(promise, fn, (Throwable)t), delayTicks);
            }
        });
        return promise;
    }

    @Override
    @Nonnull
    public Promise<V> exceptionallyDelayedAsync(@Nonnull Function<Throwable, ? extends V> fn, long delay, @Nonnull TimeUnit unit) {
        HelperPromise promise = HelperPromise.empty();
        this.fut.whenComplete((value, t) -> {
            if (t == null) {
                promise.complete(value);
            } else {
                this.executeDelayedAsync(new ExceptionallyRunnable(promise, fn, (Throwable)t), delay, unit);
            }
        });
        return promise;
    }

    private final class SupplyRunnable
    implements Runnable,
    Delegate<Supplier<V>> {
        private final Supplier<V> supplier;

        private SupplyRunnable(Supplier<V> supplier) {
            this.supplier = supplier;
        }

        @Override
        public Supplier<V> getDelegate() {
            return this.supplier;
        }

        @Override
        public void run() {
            if (HelperPromise.this.cancelled.get()) {
                return;
            }
            try {
                HelperPromise.this.fut.complete(this.supplier.get());
            }
            catch (Throwable t) {
                HelperExceptions.reportPromise(t);
                HelperPromise.this.fut.completeExceptionally(t);
            }
        }
    }

    private final class ThrowingSupplyRunnable
    implements Runnable,
    Delegate<Callable<V>> {
        private final Callable<V> supplier;

        private ThrowingSupplyRunnable(Callable<V> supplier) {
            this.supplier = supplier;
        }

        @Override
        public Callable<V> getDelegate() {
            return this.supplier;
        }

        @Override
        public void run() {
            if (HelperPromise.this.cancelled.get()) {
                return;
            }
            try {
                HelperPromise.this.fut.complete(this.supplier.call());
            }
            catch (Throwable t) {
                HelperExceptions.reportPromise(t);
                HelperPromise.this.fut.completeExceptionally(t);
            }
        }
    }

    private final class ExceptionallyRunnable<U>
    implements Runnable,
    Delegate<Function> {
        private final HelperPromise<U> promise;
        private final Function<Throwable, ? extends U> function;
        private final Throwable t;

        private ExceptionallyRunnable(HelperPromise<U> promise, Function<Throwable, ? extends U> function, Throwable t) {
            this.promise = promise;
            this.function = function;
            this.t = t;
        }

        @Override
        public Function getDelegate() {
            return this.function;
        }

        @Override
        public void run() {
            if (HelperPromise.this.cancelled.get()) {
                return;
            }
            try {
                this.promise.complete(this.function.apply(this.t));
            }
            catch (Throwable t) {
                HelperExceptions.reportPromise(t);
                this.promise.completeExceptionally(t);
            }
        }
    }

    private final class ComposeRunnable<U>
    implements Runnable,
    Delegate<Function> {
        private final HelperPromise<U> promise;
        private final Function<? super V, ? extends Promise<U>> function;
        private final V value;
        private final boolean sync;

        private ComposeRunnable(HelperPromise<U> promise, Function<? super V, ? extends Promise<U>> function, V value, boolean sync) {
            this.promise = promise;
            this.function = function;
            this.value = value;
            this.sync = sync;
        }

        @Override
        public Function getDelegate() {
            return this.function;
        }

        @Override
        public void run() {
            if (HelperPromise.this.cancelled.get()) {
                return;
            }
            try {
                Promise<U> p = this.function.apply(this.value);
                if (p == null) {
                    this.promise.complete(null);
                } else if (this.sync) {
                    p.thenAcceptSync(this.promise::complete);
                } else {
                    p.thenAcceptAsync(this.promise::complete);
                }
            }
            catch (Throwable t) {
                HelperExceptions.reportPromise(t);
                this.promise.completeExceptionally(t);
            }
        }
    }

    private final class ApplyRunnable<U>
    implements Runnable,
    Delegate<Function> {
        private final HelperPromise<U> promise;
        private final Function<? super V, ? extends U> function;
        private final V value;

        private ApplyRunnable(HelperPromise<U> promise, Function<? super V, ? extends U> function, V value) {
            this.promise = promise;
            this.function = function;
            this.value = value;
        }

        @Override
        public Function getDelegate() {
            return this.function;
        }

        @Override
        public void run() {
            if (HelperPromise.this.cancelled.get()) {
                return;
            }
            try {
                this.promise.complete(this.function.apply(this.value));
            }
            catch (Throwable t) {
                HelperExceptions.reportPromise(t);
                this.promise.completeExceptionally(t);
            }
        }
    }
}

