/*
 * Decompiled with CFR 0.152.
 */
package tsp.warehouse;

import java.io.File;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.yaml.snakeyaml.DumperOptions;
import tsp.warehouse.storage.file.JsonFileDataManager;
import tsp.warehouse.storage.file.YamlFileDataManager;

public final class Warehouse {
    public static final ExecutorService DEFAULT_EXECUTOR = Executors.newSingleThreadExecutor(r -> new Thread(r, "warehouse-thread"));

    private Warehouse() {
    }

    public static <T> JsonFileDataManager<T> json(@Nonnull File file, @Nullable Executor executor) {
        return new JsonFileDataManager(file, executor);
    }

    public static <T> JsonFileDataManager<T> json(@Nonnull File file) {
        return Warehouse.json(file, null);
    }

    public static <T> YamlFileDataManager<T> yaml(@Nonnull File file, @Nullable DumperOptions dumperOptions, @Nullable Executor executor) {
        return new YamlFileDataManager(file, dumperOptions, null);
    }

    public static <T> YamlFileDataManager<T> yaml(@Nonnull File file, @Nullable Executor executor) {
        return Warehouse.yaml(file, null, executor);
    }

    public static <T> YamlFileDataManager<T> yaml(@Nonnull File file) {
        return Warehouse.yaml(file, null);
    }
}

