/*
 * Decompiled with CFR 0.152.
 */
package tsp.nexuslib.util;

import java.util.Arrays;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public final class InventoryUtils {
    private InventoryUtils() {
    }

    public static void fillBorder(Inventory inv, ItemStack item) {
        int i;
        int size = inv.getSize();
        int rows = (size + 1) / 9;
        for (i = 0; i < 9; ++i) {
            inv.setItem(i, item);
        }
        if (size > 9) {
            for (i = size - 9; i < size; ++i) {
                inv.setItem(i, item);
            }
            for (i = 2; i <= rows - 1; ++i) {
                inv.setItem(i * 9 - 1, item);
                inv.setItem((i - 1) * 9, item);
            }
        }
    }

    public static void fillRow(Inventory inventory, int rowIndex, ItemStack itemStack, boolean onlyEmpty) {
        int x = rowIndex * 9;
        for (int i = 0; i < 9; ++i) {
            int slot = x + i;
            if (!onlyEmpty) {
                inventory.setItem(slot, itemStack);
                continue;
            }
            ItemStack slotItem = inventory.getItem(i);
            if (slotItem != null && !slotItem.getType().isAir()) continue;
            inventory.setItem(slot, itemStack);
        }
    }

    public static void fill(Inventory inventory, ItemStack item) {
        for (int i = 0; i < inventory.getSize(); ++i) {
            ItemStack slotItem = inventory.getItem(i);
            if (slotItem != null && !slotItem.getType().isAir()) continue;
            inventory.setItem(i, item);
        }
    }

    public static void binaryFill(Inventory inv, ItemStack item, int ... ignored) {
        int size = inv.getSize();
        for (int i = 0; i < size; ++i) {
            ItemStack slotItem;
            if (ignored == null || Arrays.binarySearch(ignored, i) >= 0 || (slotItem = inv.getItem(i)) != null && !slotItem.getType().isAir()) continue;
            inv.setItem(i, item);
        }
    }
}

