/*
 * Decompiled with CFR 0.152.
 */
package tsp.nexuslib.server;

import java.util.Optional;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;

public enum ServerVersion {
    v_1_7_10(5),
    v_1_8(47),
    v_1_8_3(47),
    v_1_8_8(47),
    v_1_9(107),
    v_1_9_2(109),
    v_1_9_4(110),
    v_1_10(210),
    v_1_10_1(210),
    v_1_10_2(210),
    v_1_11(315),
    v_1_11_2(316),
    v_1_12(335),
    v_1_12_1(338),
    v_1_12_2(340),
    v_1_13(393),
    v_1_13_1(401),
    v_1_13_2(404),
    v_1_14(477),
    v_1_14_1(480),
    v_1_14_2(485),
    v_1_14_3(490),
    v_1_14_4(498),
    v_1_15(573),
    v_1_15_1(575),
    v_1_15_2(578),
    v_1_16(735),
    v_1_16_1(736),
    v_1_16_2(751),
    v_1_16_3(753),
    v_1_16_4(754),
    v_1_16_5(754),
    v_1_17(755),
    v_1_17_1(756),
    v_1_18(757),
    v_1_18_1(757),
    v_1_18_2(758),
    v_1_19(759),
    v_1_19_1(760),
    v_1_19_2(760),
    v_1_20(763),
    v_1_20_1(763),
    v_1_20_2(764);

    private static final String NMS_VERSION_SUFFIX;
    private static final ServerVersion[] VALUES;
    public static ServerVersion[] reversedValues;
    private static ServerVersion cachedVersion;
    private final int protocolVersion;

    private ServerVersion(int protocolId) {
        this.protocolVersion = protocolId;
    }

    private static ServerVersion getVersionNoCache() {
        if (reversedValues[0] == null) {
            reversedValues = ServerVersion.reverse();
        }
        for (ServerVersion val : reversedValues) {
            String valName = val.name().substring(2).replace("_", ".");
            if (!Bukkit.getBukkitVersion().contains(valName)) continue;
            return val;
        }
        return null;
    }

    @Nonnull
    public static Optional<ServerVersion> getVersion() {
        if (cachedVersion == null) {
            cachedVersion = ServerVersion.getVersionNoCache();
        }
        return Optional.ofNullable(cachedVersion);
    }

    private static ServerVersion[] reverse() {
        ServerVersion[] array = ServerVersion.values();
        int i = 0;
        int j = array.length - 1;
        while (j > i) {
            ServerVersion tmp = array[j];
            array[j--] = array[i];
            array[i++] = tmp;
        }
        return array;
    }

    public static String getNMSSuffix() {
        return NMS_VERSION_SUFFIX;
    }

    public static String getNMSDirectory() {
        return "net.minecraft.server." + ServerVersion.getNMSSuffix();
    }

    public static String getOBCDirectory() {
        return "org.bukkit.craftbukkit." + ServerVersion.getNMSSuffix();
    }

    public static ServerVersion getLatest() {
        return reversedValues[1];
    }

    public static ServerVersion getOldest() {
        return ServerVersion.values()[0];
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public boolean isNewerThan(ServerVersion target) {
        if (target.protocolVersion != this.protocolVersion || this == target) {
            return this.protocolVersion > target.protocolVersion;
        }
        for (ServerVersion version : reversedValues) {
            if (version == target) {
                return false;
            }
            if (version != this) continue;
            return true;
        }
        return false;
    }

    public boolean isOlderThan(ServerVersion target) {
        if (target.protocolVersion != this.protocolVersion || this == target) {
            return this.protocolVersion < target.protocolVersion;
        }
        for (ServerVersion version : VALUES) {
            if (version == this) {
                return true;
            }
            if (version != target) continue;
            return false;
        }
        return false;
    }

    public boolean isNewerThanOrEquals(ServerVersion target) {
        return this == target || this.isNewerThan(target);
    }

    public boolean isOlderThanOrEquals(ServerVersion target) {
        return this == target || this.isOlderThan(target);
    }

    @Deprecated
    public boolean isHigherThan(ServerVersion target) {
        return this.isNewerThan(target);
    }

    @Deprecated
    public boolean isHigherThanOrEquals(ServerVersion target) {
        return this.isNewerThanOrEquals(target);
    }

    @Deprecated
    public boolean isLowerThan(ServerVersion target) {
        return this.isOlderThan(target);
    }

    @Deprecated
    public boolean isLowerThanOrEquals(ServerVersion target) {
        return this.isOlderThanOrEquals(target);
    }

    static {
        NMS_VERSION_SUFFIX = Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3];
        VALUES = ServerVersion.values();
        reversedValues = new ServerVersion[VALUES.length];
    }
}

