/*
 * Decompiled with CFR 0.152.
 */
package tsp.headdb.core.command;

import org.bukkit.command.CommandSender;
import tsp.headdb.HeadDB;
import tsp.headdb.core.api.HeadAPI;
import tsp.headdb.core.command.SubCommand;
import tsp.headdb.implementation.head.HeadResult;
import tsp.helperlite.scheduler.promise.Promise;

public class CommandUpdate
extends SubCommand {
    public CommandUpdate() {
        super("update", new String[]{"u"});
    }

    @Override
    public void handle(CommandSender sender, String[] args) {
        this.getLocalization().sendMessage(sender, "updateDatabase");
        try (Promise<HeadResult> promise = HeadAPI.getDatabase().update();){
            promise.thenAcceptSync(result -> {
                HeadDB.getInstance().getLog().debug("Database Updated! Heads: " + result.heads().values().size() + " | Took: " + result.elapsed() + "ms");
                this.getLocalization().sendMessage(sender, "updateDatabaseDone", msg -> msg.replace("%size%", String.valueOf(result.heads().values().size())));
            });
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

