/*
 * Decompiled with CFR 0.152.
 */
package tsp.nexuslib.serialization;

import java.io.Serializable;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import tsp.nexuslib.util.Validate;

public record SerializedLocation(@Nonnull UUID uniqueId, double x, double y, double z, @Nullable Float yaw, @Nullable Float pitch) implements Serializable
{
    private static final Pattern DELIMITER = Pattern.compile(";");

    public SerializedLocation(@Nonnull UUID uniqueId, double x, double y, double z) {
        this(uniqueId, x, y, z, null, null);
    }

    public static SerializedLocation of(@Nonnull Location location) {
        Validate.notNull(location, "Location can not be null!");
        Validate.notNull(location.getWorld(), "World location can not be null!");
        return new SerializedLocation(location.getWorld().getUID(), location.getX(), location.getY(), location.getZ(), Float.valueOf(location.getYaw()), Float.valueOf(location.getPitch()));
    }

    public static SerializedLocation of(@Nonnull String serializedLocation) {
        Validate.notNull(serializedLocation, "Location can not be null!");
        String[] args = DELIMITER.split(serializedLocation);
        return new SerializedLocation(UUID.fromString(args[0]), Double.parseDouble(args[1]), Double.parseDouble(args[2]), Double.parseDouble(args[3]), SerializedLocation.parseFloat(args[4]), SerializedLocation.parseFloat(args[5]));
    }

    public Optional<Location> toLocation() {
        World world = Bukkit.getWorld((UUID)this.uniqueId);
        if (world == null) {
            return Optional.empty();
        }
        if (this.yaw == null || this.pitch == null) {
            return Optional.of(new Location(world, this.x, this.y, this.z));
        }
        return Optional.of(new Location(world, this.x, this.y, this.z, this.yaw.floatValue(), this.pitch.floatValue()));
    }

    @Nonnull
    public Optional<Float> getYaw() {
        return Optional.ofNullable(this.yaw);
    }

    @Nonnull
    public Optional<Float> getPitch() {
        return Optional.ofNullable(this.pitch);
    }

    @Override
    @Nonnull
    public String toString() {
        return this.uniqueId.toString() + ";" + this.x + ";" + this.y + ";" + this.z + ";" + this.yaw + ";" + this.pitch;
    }

    private static Float parseFloat(String raw) {
        try {
            return Float.valueOf(Float.parseFloat(raw));
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }
}

