/*
 * Decompiled with CFR 0.152.
 */
package tsp.helperlite.scheduler.task.builder;

import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import tsp.helperlite.scheduler.ThreadContext;
import tsp.helperlite.scheduler.task.builder.ContextualPromiseBuilder;
import tsp.helperlite.scheduler.task.builder.ContextualTaskBuilder;
import tsp.helperlite.scheduler.task.builder.TaskBuilderImpl;

public interface TaskBuilder {
    @Nonnull
    public static TaskBuilder newBuilder() {
        return TaskBuilderImpl.INSTANCE;
    }

    @Nonnull
    default public ThreadContextual on(@Nonnull ThreadContext context) {
        switch (context) {
            case SYNC: {
                return this.sync();
            }
            case ASYNC: {
                return this.async();
            }
        }
        throw new AssertionError();
    }

    @Nonnull
    public ThreadContextual sync();

    @Nonnull
    public ThreadContextual async();

    public static interface ThreadContextual {
        @Nonnull
        public ContextualPromiseBuilder now();

        @Nonnull
        public DelayedTick after(long var1);

        @Nonnull
        public DelayedTime after(long var1, @Nonnull TimeUnit var3);

        @Nonnull
        public ContextualTaskBuilder afterAndEvery(long var1);

        @Nonnull
        public ContextualTaskBuilder afterAndEvery(long var1, @Nonnull TimeUnit var3);

        @Nonnull
        public ContextualTaskBuilder every(long var1);

        @Nonnull
        public ContextualTaskBuilder every(long var1, @Nonnull TimeUnit var3);
    }

    public static interface DelayedTime
    extends Delayed {
        @Nonnull
        public ContextualTaskBuilder every(long var1, TimeUnit var3);
    }

    public static interface DelayedTick
    extends Delayed {
        @Nonnull
        public ContextualTaskBuilder every(long var1);
    }

    public static interface Delayed
    extends ContextualPromiseBuilder {
    }
}

