/*
 * Decompiled with CFR 0.152.
 */
package tsp.helperlite.command.functional;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import tsp.helperlite.command.AbstractCommand;
import tsp.helperlite.command.CommandInterruptException;
import tsp.helperlite.command.context.CommandContext;
import tsp.helperlite.command.functional.FunctionalCommandHandler;
import tsp.helperlite.command.functional.FunctionalTabHandler;

@ParametersAreNonnullByDefault
class FunctionalCommand
extends AbstractCommand {
    private final ImmutableList<Predicate<CommandContext<?>>> predicates;
    private final FunctionalCommandHandler handler;
    @Nullable
    private final FunctionalTabHandler tabHandler;

    FunctionalCommand(ImmutableList<Predicate<CommandContext<?>>> predicates, FunctionalCommandHandler handler, @Nullable FunctionalTabHandler tabHandler, @Nullable String permission, @Nullable String permissionMessage, @Nullable String description) {
        this.predicates = predicates;
        this.handler = handler;
        this.tabHandler = tabHandler;
        this.permission = permission;
        this.permissionMessage = permissionMessage;
        this.description = description;
    }

    @Override
    public void call(@Nonnull CommandContext<?> context) throws CommandInterruptException {
        for (Predicate predicate : this.predicates) {
            if (predicate.test(context)) continue;
            return;
        }
        this.handler.handle(context);
    }

    @Override
    @Nullable
    public List<String> callTabCompleter(@Nonnull CommandContext<?> context) throws CommandInterruptException {
        if (this.tabHandler == null) {
            return null;
        }
        for (Predicate predicate : this.predicates) {
            if (predicate.test(context)) continue;
            return null;
        }
        return this.tabHandler.handle(context);
    }
}

