/*
 * Decompiled with CFR 0.152.
 */
package tsp.headdb.core.command;

import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import tsp.headdb.core.api.HeadAPI;
import tsp.headdb.core.command.SubCommand;
import tsp.headdb.core.util.Utils;
import tsp.headdb.implementation.head.Head;

public class CommandGive
extends SubCommand {
    public CommandGive() {
        super("give", HeadAPI.getHeads().stream().map(Head::getName).collect(Collectors.toList()), "g");
    }

    @Override
    public void handle(CommandSender sender, String[] args) {
        Optional<Head> head;
        if (args.length < 3) {
            this.getLocalization().sendMessage(sender, "invalidArguments");
            return;
        }
        int amount = args.length >= 4 ? Utils.resolveInt(args[3]) : 1;
        String id = args[1];
        if (id.startsWith("t:")) {
            head = HeadAPI.getHeadByTexture(id.substring(2));
        } else {
            try {
                head = HeadAPI.getHeadById(Integer.parseInt(id));
            }
            catch (NumberFormatException nfe) {
                head = HeadAPI.getHeadByExactName(id);
            }
        }
        Player player = Bukkit.getPlayer((String)args[2]);
        if (player == null) {
            this.getLocalization().sendMessage(sender, "invalidTarget", msg -> msg.replace("%name%", args[2]));
            return;
        }
        head.ifPresentOrElse(value -> {
            player.getInventory().addItem(new ItemStack[]{value.getItem(player.getUniqueId())});
            this.getLocalization().sendMessage(sender, "giveCommand", msg -> msg.replace("%size%", String.valueOf(amount)).replace("%name%", value.getName()).replace("%receiver%", player.getName()));
        }, () -> this.getLocalization().sendMessage(sender, "giveCommandInvalid", msg -> msg.replace("%name%", id)));
    }
}

