/*
 * Decompiled with CFR 0.152.
 */
package tsp.warehouse.storage.file;

import java.io.File;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import tsp.warehouse.storage.DataManager;
import tsp.warehouse.storage.util.WHValidate;

public abstract class FileDataManager<T>
implements DataManager<T> {
    private File file;
    private Executor executor;

    public FileDataManager(@Nonnull File file, @Nullable Executor executor) {
        WHValidate.notNull(file, "File can not be null!");
        this.file = file;
        this.executor = executor != null ? executor : Executors.newSingleThreadExecutor();
    }

    public boolean createFileIfNotExist() {
        if (!this.getFile().exists() && this.getFile().getParentFile() != null && !this.getFile().getParentFile().exists()) {
            return this.getFile().getParentFile().mkdirs();
        }
        return false;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }
}

