/*
 * Decompiled with CFR 0.152.
 */
package tsp.warehouse.storage.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import tsp.warehouse.storage.file.FileDataManager;

public class YamlFileDataManager<T>
extends FileDataManager<T> {
    private Yaml yaml;

    public YamlFileDataManager(@Nonnull File file, @Nullable DumperOptions dumperOptions, @Nullable Executor executor) {
        super(file, executor);
        this.yaml = dumperOptions != null ? new Yaml(dumperOptions) : new Yaml();
    }

    public YamlFileDataManager(@Nonnull File file) {
        this(file, null, null);
    }

    @Override
    public CompletableFuture<Optional<T>> load() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                FileReader reader = new FileReader(this.getFile());
                return Optional.of(this.yaml.load(reader));
            }
            catch (FileNotFoundException ex) {
                throw new CompletionException(ex);
            }
        }, this.getExecutor());
    }

    @Override
    public CompletableFuture<Boolean> save(T t) {
        return CompletableFuture.supplyAsync(() -> {
            try (FileWriter writer = new FileWriter(this.getFile());){
                this.yaml.dump(t, writer);
                Boolean bl = true;
                return bl;
            }
            catch (IOException ex) {
                throw new CompletionException(ex);
            }
        }, this.getExecutor());
    }

    public Yaml getYaml() {
        return this.yaml;
    }

    public YamlFileDataManager<T> yaml(Yaml yaml) {
        this.yaml = yaml;
        return this;
    }
}

