/*
 * Decompiled with CFR 0.152.
 */
package tsp.nexuslib.util.potion;

import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import tsp.nexuslib.util.Validate;

public enum Potion {
    SPEED(PotionEffectType.SPEED),
    SLOWNESS(PotionEffectType.SLOW),
    HASTE(PotionEffectType.FAST_DIGGING),
    MINING_FATIGUE(PotionEffectType.SLOW_DIGGING),
    STRENGTH(PotionEffectType.INCREASE_DAMAGE),
    INSTANT_HEALTH(PotionEffectType.HEAL),
    INSTANT_DAMAGE(PotionEffectType.HARM),
    JUMP_BOOST(PotionEffectType.JUMP),
    NAUSEA(PotionEffectType.CONFUSION),
    REGENERATION(PotionEffectType.REGENERATION),
    RESISTANCE(PotionEffectType.DAMAGE_RESISTANCE),
    FIRE_RESISTANCE(PotionEffectType.FIRE_RESISTANCE),
    WATER_BREATHING(PotionEffectType.WATER_BREATHING),
    INVISIBILITY(PotionEffectType.INVISIBILITY),
    BLINDNESS(PotionEffectType.BLINDNESS),
    NIGHT_VISION(PotionEffectType.NIGHT_VISION),
    HUNGER(PotionEffectType.HUNGER),
    WEAKNESS(PotionEffectType.WEAKNESS),
    POISON(PotionEffectType.POISON),
    WITHER(PotionEffectType.WITHER),
    HEALTH_BOOST(PotionEffectType.HEALTH_BOOST),
    ABSORPTION(PotionEffectType.ABSORPTION),
    SATURATION(PotionEffectType.SATURATION),
    GLOWING(PotionEffectType.GLOWING),
    LEVITATION(PotionEffectType.LEVITATION),
    LUCK(PotionEffectType.LUCK),
    UNLUCK(PotionEffectType.UNLUCK),
    SLOW_FALLING(PotionEffectType.SLOW_FALLING),
    CONDUIT_POWER(PotionEffectType.CONFUSION),
    DOLPHINS_GRACE(PotionEffectType.DOLPHINS_GRACE),
    BAD_OMEN(PotionEffectType.BAD_OMEN),
    HERO_OF_THE_VILLAGE(PotionEffectType.HERO_OF_THE_VILLAGE),
    DARKNESS(PotionEffectType.DARKNESS);

    private final PotionEffectType type;

    private Potion(PotionEffectType type) {
        this.type = type;
    }

    public PotionEffectType getType() {
        return this.type;
    }

    public boolean apply(LivingEntity entity, int seconds, int amplifier) {
        Validate.notNull(entity, "Entity can not be null!");
        return entity.addPotionEffect(new PotionEffect(this.type, seconds * 20, amplifier - 1));
    }

    public boolean apply(LivingEntity entity, int seconds) {
        Validate.notNull(entity, "Entity can not be null!");
        return this.apply(entity, seconds, 1);
    }

    public boolean applyRaw(LivingEntity entity, int ticks, int amplifier) {
        Validate.notNull(entity, "Entity can not be null!");
        return entity.addPotionEffect(new PotionEffect(this.type, ticks, amplifier));
    }

    public boolean applyRaw(LivingEntity entity, int ticks) {
        Validate.notNull(entity, "Entity can not be null!");
        return entity.addPotionEffect(new PotionEffect(this.type, ticks, 0));
    }

    public boolean apply(ItemStack item, int seconds, int amplifier) {
        Validate.notNull(item, "Item can not be null!");
        ItemMeta itemMeta = item.getItemMeta();
        if (!(itemMeta instanceof PotionMeta)) {
            throw new IllegalArgumentException("Item can not contain potion meta!");
        }
        PotionMeta meta = (PotionMeta)itemMeta;
        meta.addCustomEffect(new PotionEffect(this.type, seconds * 20, amplifier - 1), true);
        return item.setItemMeta((ItemMeta)meta);
    }

    public boolean apply(ItemStack item, int seconds) {
        Validate.notNull(item, "Item can not be null!");
        return this.apply(item, seconds, 1);
    }

    public boolean applyRaw(ItemStack item, int ticks, int amplifier) {
        Validate.notNull(item, "Item can not be null!");
        ItemMeta itemMeta = item.getItemMeta();
        if (!(itemMeta instanceof PotionMeta)) {
            throw new IllegalArgumentException("Item can not contain potion meta!");
        }
        PotionMeta meta = (PotionMeta)itemMeta;
        meta.addCustomEffect(new PotionEffect(this.type, ticks, amplifier), true);
        return item.setItemMeta((ItemMeta)meta);
    }

    public boolean applyRaw(ItemStack item, int ticks) {
        Validate.notNull(item, "Item can not be null!");
        return this.applyRaw(item, ticks, 0);
    }

    public Optional<ItemStack> asItem(Material potionItem, int ticks, int amplifier) {
        Validate.notNull(potionItem, "Material can not be null!");
        if (!this.isPotion(potionItem)) {
            throw new IllegalArgumentException("Material must be of potion type!");
        }
        ItemStack item = new ItemStack(potionItem);
        ItemMeta itemMeta = item.getItemMeta();
        if (!(itemMeta instanceof PotionMeta)) {
            return Optional.empty();
        }
        PotionMeta meta = (PotionMeta)itemMeta;
        meta.addCustomEffect(new PotionEffect(this.type, ticks, amplifier), true);
        item.setItemMeta((ItemMeta)meta);
        return Optional.of(item);
    }

    public boolean isPotion(Material material) {
        return switch (material) {
            case Material.POTION, Material.SPLASH_POTION, Material.LINGERING_POTION -> true;
            default -> false;
        };
    }
}

