/*
 * Decompiled with CFR 0.152.
 */
package tsp.nexuslib.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;

public final class StringUtils {
    private static final Pattern HEX_PATTERN = Pattern.compile("(#[A-Fa-f0-9]{6})");

    private StringUtils() {
    }

    public static String joinArgs(int start, int end, String delimiter, String ... args) {
        return String.join((CharSequence)delimiter, Arrays.copyOfRange(args, start, end));
    }

    public static String joinArgs(int start, String ... args) {
        return StringUtils.joinArgs(start, args.length, " ", args);
    }

    public static String joinArgs(String ... args) {
        return StringUtils.joinArgs(0, args.length, " ", args);
    }

    public static List<String> colorize(List<String> list) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            result.add(i, list.get(i));
        }
        return result;
    }

    public static String colorize(String string) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)string);
    }

    public static String hex(String string) {
        Matcher matcher = HEX_PATTERN.matcher(string);
        while (matcher.find()) {
            string = string.replace(matcher.group(), "" + net.md_5.bungee.api.ChatColor.of((String)matcher.group()));
        }
        return string;
    }

    public static String gradient(String string, ChatColor ... colors) {
        StringBuilder builder = new StringBuilder();
        int color = 0;
        for (char c : string.toCharArray()) {
            builder.append(colors[color]).append(c);
            color = color + 1 < colors.length ? color + 1 : 0;
        }
        return builder.toString();
    }

    public static String gradientWord(String string, String delimiter, ChatColor ... colors) {
        String[] args = string.split(delimiter);
        StringBuilder builder = new StringBuilder();
        int color = 0;
        for (String arg : args) {
            builder.append(colors[color]).append(arg);
        }
        return builder.toString();
    }

    public static String gradientWord(String string, Pattern delimiter, ChatColor ... colors) {
        String[] args = delimiter.split(string);
        StringBuilder builder = new StringBuilder();
        int color = 0;
        for (String arg : args) {
            builder.append(colors[color]).append(arg);
        }
        return builder.toString();
    }

    public static String capitalize(String string) {
        return string.substring(0, 1).toUpperCase(Locale.ROOT) + string.substring(1);
    }

    public static String capitalizeWords(String string, Pattern delimiter) {
        String[] words;
        StringBuilder builder = new StringBuilder();
        for (String word : words = delimiter.split(string)) {
            builder.append(StringUtils.capitalize(word)).append(delimiter);
        }
        return builder.toString();
    }

    public static String capitalizeWords(String string) {
        return StringUtils.capitalizeWords(string, Pattern.compile(" "));
    }

    public static String splitCapitals(String string) {
        StringBuilder builder = new StringBuilder();
        char[] chars = string.toCharArray();
        builder.append(chars[0]);
        for (int i = 1; i < chars.length; ++i) {
            if (Character.isUpperCase(chars[i])) {
                builder.append(" ");
            }
            builder.append(chars[i]);
        }
        return builder.toString();
    }
}

