/*
 * Decompiled with CFR 0.152.
 */
package tsp.nexuslib.mojang;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import org.bukkit.plugin.java.JavaPlugin;
import tsp.nexuslib.player.info.NameHistory;
import tsp.nexuslib.player.info.SkinInfo;

public class MojangAPI {
    private final JavaPlugin plugin;
    private final Executor executor;

    public MojangAPI(JavaPlugin plugin, Executor executor) {
        this.plugin = plugin;
        this.executor = executor;
    }

    public CompletableFuture<UUID> getUniqueId(String name, int timeout) {
        return this.getUniqueIdJson(name, timeout).thenApply(json -> UUID.fromString(json.get("id").toString()));
    }

    public CompletableFuture<UUID> getUniqueId(String name) {
        return this.getUniqueId(name, 5000);
    }

    public CompletableFuture<SkinInfo> getSkinInfo(UUID uuid, int timeout) {
        return this.getSkinInfoJson(uuid, timeout).thenApply(json -> {
            JsonArray properties = json.get("properties").getAsJsonArray();
            JsonObject textures = properties.get(0).getAsJsonObject();
            String id = json.get("id").toString();
            String name = json.get("name").toString();
            String value = textures.get("value").toString();
            String signature = textures.get("signature").toString();
            return new SkinInfo(id, name, value, signature);
        });
    }

    public CompletableFuture<SkinInfo> getSkinInfo(UUID uuid) {
        return this.getSkinInfo(uuid, 5000);
    }

    public CompletableFuture<NameHistory> getNameHistory(UUID uuid, int timeout) {
        return this.getNameHistoryJson(uuid, timeout).thenApply(json -> {
            HashMap<String, Long> history = new HashMap<String, Long>();
            for (JsonElement e : json) {
                JsonObject obj = e.getAsJsonObject();
                String name = obj.get("name").toString();
                long timestamp = obj.get("changedToAt") != null ? obj.get("changedToAt").getAsLong() : -1L;
                history.put(name, timestamp);
            }
            return new NameHistory(uuid, history);
        });
    }

    public CompletableFuture<NameHistory> getNameHistory(UUID uuid) {
        return this.getNameHistory(uuid, 5000);
    }

    public CompletableFuture<JsonObject> getUniqueIdJson(String name, int timeout) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                String req = "https://api.mojang.com/users/profiles/minecraft/" + name;
                URLConnection connection = new URL(req).openConnection();
                connection.setConnectTimeout(timeout);
                connection.setRequestProperty("User-Agent", this.plugin.getName() + "-UUIDFetcher");
                connection.setRequestProperty("Accept", "application/json");
                StringBuilder response = new StringBuilder();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        response.append(line);
                    }
                }
                return JsonParser.parseString((String)response.toString()).getAsJsonObject();
            }
            catch (IOException ex) {
                throw new CompletionException(ex);
            }
        });
    }

    public CompletableFuture<JsonObject> getUniqueIdJson(String name) {
        return this.getUniqueIdJson(name, 5000);
    }

    public CompletableFuture<JsonObject> getSkinInfoJson(UUID uuid, int timeout) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                String req = "https://sessionserver.mojang.com/session/minecraft/profile/" + uuid.toString().replace("-", "") + "?unsigned=false";
                URLConnection connection = new URL(req).openConnection();
                connection.setConnectTimeout(timeout);
                connection.setRequestProperty("User-Agent", this.plugin.getName() + "-SkinFetcher");
                connection.setRequestProperty("Accept", "application/json");
                StringBuilder response = new StringBuilder();
                try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                    String line;
                    while ((line = in.readLine()) != null) {
                        response.append(line);
                    }
                }
                return JsonParser.parseString((String)response.toString()).getAsJsonObject();
            }
            catch (IOException ex) {
                throw new CompletionException(ex);
            }
        }, this.executor);
    }

    public CompletableFuture<JsonObject> getSkinInfoJson(UUID uuid) {
        return this.getSkinInfoJson(uuid, 5000);
    }

    public CompletableFuture<JsonArray> getNameHistoryJson(UUID uuid, int timeout) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                String req = "https://api.mojang.com/user/profiles/" + uuid.toString().replace("-", "") + "/names";
                URLConnection connection = new URL(req).openConnection();
                connection.setConnectTimeout(timeout);
                connection.setRequestProperty("User-Agent", this.plugin.getName() + "-NameHistoryFetcher");
                connection.setRequestProperty("Accept", "application/json");
                StringBuilder response = new StringBuilder();
                try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                    String line;
                    while ((line = in.readLine()) != null) {
                        response.append(line);
                    }
                }
                return JsonParser.parseString((String)response.toString()).getAsJsonArray();
            }
            catch (IOException ex) {
                throw new CompletionException(ex);
            }
        }, this.executor);
    }

    public CompletableFuture<JsonArray> getNameHistoryJson(UUID uuid) {
        return this.getNameHistoryJson(uuid, 5000);
    }

    public CompletableFuture<List<String>> getBlockedServers(int timeout) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                String req = "https://sessionserver.mojang.com/blockedservers";
                ArrayList<String> blockedServers = new ArrayList<String>();
                URLConnection connection = new URL(req).openConnection();
                connection.setConnectTimeout(timeout);
                connection.setRequestProperty("User-Agent", this.plugin.getName() + "-BlockedServersFetcher");
                connection.setRequestProperty("Accept", "application/json");
                try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                    String line;
                    while ((line = in.readLine()) != null) {
                        blockedServers.add(line);
                    }
                }
                return blockedServers;
            }
            catch (IOException ex) {
                throw new CompletionException(ex);
            }
        }, this.executor);
    }

    public CompletableFuture<List<String>> getBlockedServers() {
        return this.getBlockedServers(5000);
    }
}

